/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.efs.model.FileSystemSize;
import software.amazon.awssdk.services.efs.model.LifeCycleState;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.services.efs.model.ThroughputMode;
import software.amazon.awssdk.services.efs.transform.FileSystemDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSystemDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, FileSystemDescription> {
    private final String ownerId;
    private final String creationToken;
    private final String fileSystemId;
    private final Instant creationTime;
    private final String lifeCycleState;
    private final String name;
    private final Integer numberOfMountTargets;
    private final FileSystemSize sizeInBytes;
    private final String performanceMode;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String throughputMode;
    private final Double provisionedThroughputInMibps;

    private FileSystemDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
        this.creationTime = builder.creationTime;
        this.lifeCycleState = builder.lifeCycleState;
        this.name = builder.name;
        this.numberOfMountTargets = builder.numberOfMountTargets;
        this.sizeInBytes = builder.sizeInBytes;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(this.lifeCycleState);
    }

    public String lifeCycleStateAsString() {
        return this.lifeCycleState;
    }

    public String name() {
        return this.name;
    }

    public Integer numberOfMountTargets() {
        return this.numberOfMountTargets;
    }

    public FileSystemSize sizeInBytes() {
        return this.sizeInBytes;
    }

    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public String performanceModeAsString() {
        return this.performanceMode;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public String throughputModeAsString() {
        return this.throughputMode;
    }

    public Double provisionedThroughputInMibps() {
        return this.provisionedThroughputInMibps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputInMibps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemDescription)) {
            return false;
        }
        FileSystemDescription other = (FileSystemDescription)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lifeCycleStateAsString(), other.lifeCycleStateAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.numberOfMountTargets(), other.numberOfMountTargets()) && Objects.equals(this.sizeInBytes(), other.sizeInBytes()) && Objects.equals(this.performanceModeAsString(), other.performanceModeAsString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.provisionedThroughputInMibps(), other.provisionedThroughputInMibps());
    }

    public String toString() {
        return ToString.builder((String)"FileSystemDescription").add("OwnerId", (Object)this.ownerId()).add("CreationToken", (Object)this.creationToken()).add("FileSystemId", (Object)this.fileSystemId()).add("CreationTime", (Object)this.creationTime()).add("LifeCycleState", (Object)this.lifeCycleStateAsString()).add("Name", (Object)this.name()).add("NumberOfMountTargets", (Object)this.numberOfMountTargets()).add("SizeInBytes", (Object)this.sizeInBytes()).add("PerformanceMode", (Object)this.performanceModeAsString()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ThroughputMode", (Object)this.throughputModeAsString()).add("ProvisionedThroughputInMibps", (Object)this.provisionedThroughputInMibps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreationToken": {
                return Optional.ofNullable(clazz.cast(this.creationToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LifeCycleState": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStateAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NumberOfMountTargets": {
                return Optional.ofNullable(clazz.cast(this.numberOfMountTargets()));
            }
            case "SizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInBytes()));
            }
            case "PerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.performanceModeAsString()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ThroughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "ProvisionedThroughputInMibps": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputInMibps()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileSystemDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private String creationToken;
        private String fileSystemId;
        private Instant creationTime;
        private String lifeCycleState;
        private String name;
        private Integer numberOfMountTargets;
        private FileSystemSize sizeInBytes;
        private String performanceMode;
        private Boolean encrypted;
        private String kmsKeyId;
        private String throughputMode;
        private Double provisionedThroughputInMibps;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemDescription model) {
            this.ownerId(model.ownerId);
            this.creationToken(model.creationToken);
            this.fileSystemId(model.fileSystemId);
            this.creationTime(model.creationTime);
            this.lifeCycleState(model.lifeCycleState);
            this.name(model.name);
            this.numberOfMountTargets(model.numberOfMountTargets);
            this.sizeInBytes(model.sizeInBytes);
            this.performanceMode(model.performanceMode);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.throughputMode(model.throughputMode);
            this.provisionedThroughputInMibps(model.provisionedThroughputInMibps);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLifeCycleState() {
            return this.lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getNumberOfMountTargets() {
            return this.numberOfMountTargets;
        }

        @Override
        public final Builder numberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
            return this;
        }

        public final void setNumberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
        }

        public final FileSystemSize.Builder getSizeInBytes() {
            return this.sizeInBytes != null ? this.sizeInBytes.toBuilder() : null;
        }

        @Override
        public final Builder sizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(FileSystemSize.BuilderImpl sizeInBytes) {
            this.sizeInBytes = sizeInBytes != null ? sizeInBytes.build() : null;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        public FileSystemDescription build() {
            return new FileSystemDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FileSystemDescription> {
        public Builder ownerId(String var1);

        public Builder creationToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder creationTime(Instant var1);

        public Builder lifeCycleState(String var1);

        public Builder lifeCycleState(LifeCycleState var1);

        public Builder name(String var1);

        public Builder numberOfMountTargets(Integer var1);

        public Builder sizeInBytes(FileSystemSize var1);

        default public Builder sizeInBytes(Consumer<FileSystemSize.Builder> sizeInBytes) {
            return this.sizeInBytes((FileSystemSize)((FileSystemSize.Builder)FileSystemSize.builder().applyMutation(sizeInBytes)).build());
        }

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder provisionedThroughputInMibps(Double var1);
    }
}

