/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MountTargetDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").isBinary(false).build();
    private static final MarshallingInfo<String> MOUNTTARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountTargetId").isBinary(false).build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> NETWORKINTERFACEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkInterfaceId").isBinary(false).build();
    private static final MountTargetDescriptionMarshaller INSTANCE = new MountTargetDescriptionMarshaller();

    private MountTargetDescriptionMarshaller() {
    }

    public static MountTargetDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MountTargetDescription mountTargetDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mountTargetDescription, (String)"mountTargetDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mountTargetDescription.ownerId(), OWNERID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.mountTargetId(), MOUNTTARGETID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.lifeCycleStateAsString(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)mountTargetDescription.networkInterfaceId(), NETWORKINTERFACEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

