/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.efs.transform.FileSystemSizeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FileSystemSize
implements StructuredPojo,
ToCopyableBuilder<Builder, FileSystemSize> {
    private final Long value;
    private final Date timestamp;

    private FileSystemSize(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    public Long value() {
        return this.value;
    }

    public Date timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemSize)) {
            return false;
        }
        FileSystemSize other = (FileSystemSize)obj;
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        return other.timestamp() == null || other.timestamp().equals(this.timestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileSystemSizeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Long value;
        private Date timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemSize model) {
            this.setValue(model.value);
            this.setTimestamp(model.timestamp);
        }

        public final Long getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        public final Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy((Date)timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy((Date)timestamp);
        }

        public FileSystemSize build() {
            return new FileSystemSize(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FileSystemSize> {
        public Builder value(Long var1);

        public Builder timestamp(Date var1);
    }
}

