/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapacityProviderType {
    EC2_AUTOSCALING("EC2_AUTOSCALING"),
    MANAGED_INSTANCES("MANAGED_INSTANCES"),
    FARGATE("FARGATE"),
    FARGATE_SPOT("FARGATE_SPOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapacityProviderType> VALUE_MAP;
    private final String value;

    private CapacityProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapacityProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapacityProviderType> knownValues() {
        EnumSet<CapacityProviderType> knownValues = EnumSet.allOf(CapacityProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapacityProviderType.class, CapacityProviderType::toString);
    }
}

