/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceConfiguration;
import software.amazon.awssdk.services.ecs.model.ExpressGatewayServiceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatedExpressGatewayService
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatedExpressGatewayService> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceArn").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::serviceArn)).setter(UpdatedExpressGatewayService.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()}).build();
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::cluster)).setter(UpdatedExpressGatewayService.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceName").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::serviceName)).setter(UpdatedExpressGatewayService.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<ExpressGatewayServiceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::status)).setter(UpdatedExpressGatewayService.setter(Builder::status)).constructor(ExpressGatewayServiceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ExpressGatewayServiceConfiguration> TARGET_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetConfiguration").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::targetConfiguration)).setter(UpdatedExpressGatewayService.setter(Builder::targetConfiguration)).constructor(ExpressGatewayServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::createdAt)).setter(UpdatedExpressGatewayService.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdatedExpressGatewayService.getter(UpdatedExpressGatewayService::updatedAt)).setter(UpdatedExpressGatewayService.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD, CLUSTER_FIELD, SERVICE_NAME_FIELD, STATUS_FIELD, TARGET_CONFIGURATION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatedExpressGatewayService.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceArn;
    private final String cluster;
    private final String serviceName;
    private final ExpressGatewayServiceStatus status;
    private final ExpressGatewayServiceConfiguration targetConfiguration;
    private final Instant createdAt;
    private final Instant updatedAt;

    private UpdatedExpressGatewayService(BuilderImpl builder) {
        this.serviceArn = builder.serviceArn;
        this.cluster = builder.cluster;
        this.serviceName = builder.serviceName;
        this.status = builder.status;
        this.targetConfiguration = builder.targetConfiguration;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final ExpressGatewayServiceStatus status() {
        return this.status;
    }

    public final ExpressGatewayServiceConfiguration targetConfiguration() {
        return this.targetConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatedExpressGatewayService)) {
            return false;
        }
        UpdatedExpressGatewayService other = (UpdatedExpressGatewayService)obj;
        return Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.targetConfiguration(), other.targetConfiguration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatedExpressGatewayService").add("ServiceArn", (Object)this.serviceArn()).add("Cluster", (Object)this.cluster()).add("ServiceName", (Object)this.serviceName()).add("Status", (Object)this.status()).add("TargetConfiguration", (Object)this.targetConfiguration()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "serviceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "targetConfiguration": {
                return Optional.ofNullable(clazz.cast(this.targetConfiguration()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("cluster", CLUSTER_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("targetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatedExpressGatewayService, T> g) {
        return obj -> g.apply((UpdatedExpressGatewayService)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceArn;
        private String cluster;
        private String serviceName;
        private ExpressGatewayServiceStatus status;
        private ExpressGatewayServiceConfiguration targetConfiguration;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatedExpressGatewayService model) {
            this.serviceArn(model.serviceArn);
            this.cluster(model.cluster);
            this.serviceName(model.serviceName);
            this.status(model.status);
            this.targetConfiguration(model.targetConfiguration);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final ExpressGatewayServiceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(ExpressGatewayServiceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ExpressGatewayServiceStatus status) {
            this.status = status;
            return this;
        }

        public final ExpressGatewayServiceConfiguration.Builder getTargetConfiguration() {
            return this.targetConfiguration != null ? this.targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(ExpressGatewayServiceConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(ExpressGatewayServiceConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public UpdatedExpressGatewayService build() {
            return new UpdatedExpressGatewayService(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatedExpressGatewayService> {
        public Builder serviceArn(String var1);

        public Builder cluster(String var1);

        public Builder serviceName(String var1);

        public Builder status(ExpressGatewayServiceStatus var1);

        default public Builder status(Consumer<ExpressGatewayServiceStatus.Builder> status) {
            return this.status((ExpressGatewayServiceStatus)((ExpressGatewayServiceStatus.Builder)ExpressGatewayServiceStatus.builder().applyMutation(status)).build());
        }

        public Builder targetConfiguration(ExpressGatewayServiceConfiguration var1);

        default public Builder targetConfiguration(Consumer<ExpressGatewayServiceConfiguration.Builder> targetConfiguration) {
            return this.targetConfiguration((ExpressGatewayServiceConfiguration)((ExpressGatewayServiceConfiguration.Builder)ExpressGatewayServiceConfiguration.builder().applyMutation(targetConfiguration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

