/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.AttachmentStateChange;
import software.amazon.awssdk.services.ecs.model.AttachmentStateChangesCopier;
import software.amazon.awssdk.services.ecs.model.ContainerStateChange;
import software.amazon.awssdk.services.ecs.model.ContainerStateChangesCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.ManagedAgentStateChange;
import software.amazon.awssdk.services.ecs.model.ManagedAgentStateChangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitTaskStateChangeRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, SubmitTaskStateChangeRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::cluster)).setter(SubmitTaskStateChangeRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("task").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::task)).setter(SubmitTaskStateChangeRequest.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::status)).setter(SubmitTaskStateChangeRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::reason)).setter(SubmitTaskStateChangeRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<ContainerStateChange>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::containers)).setter(SubmitTaskStateChangeRequest.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachmentStateChange>> ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachments").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::attachments)).setter(SubmitTaskStateChangeRequest.setter(Builder::attachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachmentStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ManagedAgentStateChange>> MANAGED_AGENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedAgents").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::managedAgents)).setter(SubmitTaskStateChangeRequest.setter(Builder::managedAgents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedAgents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ManagedAgentStateChange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> PULL_STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pullStartedAt").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::pullStartedAt)).setter(SubmitTaskStateChangeRequest.setter(Builder::pullStartedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStartedAt").build()}).build();
    private static final SdkField<Instant> PULL_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("pullStoppedAt").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::pullStoppedAt)).setter(SubmitTaskStateChangeRequest.setter(Builder::pullStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullStoppedAt").build()}).build();
    private static final SdkField<Instant> EXECUTION_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionStoppedAt").getter(SubmitTaskStateChangeRequest.getter(SubmitTaskStateChangeRequest::executionStoppedAt)).setter(SubmitTaskStateChangeRequest.setter(Builder::executionStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStoppedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD, STATUS_FIELD, REASON_FIELD, CONTAINERS_FIELD, ATTACHMENTS_FIELD, MANAGED_AGENTS_FIELD, PULL_STARTED_AT_FIELD, PULL_STOPPED_AT_FIELD, EXECUTION_STOPPED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubmitTaskStateChangeRequest.memberNameToFieldInitializer();
    private final String cluster;
    private final String task;
    private final String status;
    private final String reason;
    private final List<ContainerStateChange> containers;
    private final List<AttachmentStateChange> attachments;
    private final List<ManagedAgentStateChange> managedAgents;
    private final Instant pullStartedAt;
    private final Instant pullStoppedAt;
    private final Instant executionStoppedAt;

    private SubmitTaskStateChangeRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.status = builder.status;
        this.reason = builder.reason;
        this.containers = builder.containers;
        this.attachments = builder.attachments;
        this.managedAgents = builder.managedAgents;
        this.pullStartedAt = builder.pullStartedAt;
        this.pullStoppedAt = builder.pullStoppedAt;
        this.executionStoppedAt = builder.executionStoppedAt;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final String task() {
        return this.task;
    }

    public final String status() {
        return this.status;
    }

    public final String reason() {
        return this.reason;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<ContainerStateChange> containers() {
        return this.containers;
    }

    public final boolean hasAttachments() {
        return this.attachments != null && !(this.attachments instanceof SdkAutoConstructList);
    }

    public final List<AttachmentStateChange> attachments() {
        return this.attachments;
    }

    public final boolean hasManagedAgents() {
        return this.managedAgents != null && !(this.managedAgents instanceof SdkAutoConstructList);
    }

    public final List<ManagedAgentStateChange> managedAgents() {
        return this.managedAgents;
    }

    public final Instant pullStartedAt() {
        return this.pullStartedAt;
    }

    public final Instant pullStoppedAt() {
        return this.pullStoppedAt;
    }

    public final Instant executionStoppedAt() {
        return this.executionStoppedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachments() ? this.attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedAgents() ? this.managedAgents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullStoppedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStoppedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitTaskStateChangeRequest)) {
            return false;
        }
        SubmitTaskStateChangeRequest other = (SubmitTaskStateChangeRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.reason(), other.reason()) && this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && this.hasAttachments() == other.hasAttachments() && Objects.equals(this.attachments(), other.attachments()) && this.hasManagedAgents() == other.hasManagedAgents() && Objects.equals(this.managedAgents(), other.managedAgents()) && Objects.equals(this.pullStartedAt(), other.pullStartedAt()) && Objects.equals(this.pullStoppedAt(), other.pullStoppedAt()) && Objects.equals(this.executionStoppedAt(), other.executionStoppedAt());
    }

    public final String toString() {
        return ToString.builder((String)"SubmitTaskStateChangeRequest").add("Cluster", (Object)this.cluster()).add("Task", (Object)this.task()).add("Status", (Object)this.status()).add("Reason", (Object)this.reason()).add("Containers", this.hasContainers() ? this.containers() : null).add("Attachments", this.hasAttachments() ? this.attachments() : null).add("ManagedAgents", this.hasManagedAgents() ? this.managedAgents() : null).add("PullStartedAt", (Object)this.pullStartedAt()).add("PullStoppedAt", (Object)this.pullStoppedAt()).add("ExecutionStoppedAt", (Object)this.executionStoppedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "attachments": {
                return Optional.ofNullable(clazz.cast(this.attachments()));
            }
            case "managedAgents": {
                return Optional.ofNullable(clazz.cast(this.managedAgents()));
            }
            case "pullStartedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStartedAt()));
            }
            case "pullStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.pullStoppedAt()));
            }
            case "executionStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.executionStoppedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("task", TASK_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("reason", REASON_FIELD);
        map.put("containers", CONTAINERS_FIELD);
        map.put("attachments", ATTACHMENTS_FIELD);
        map.put("managedAgents", MANAGED_AGENTS_FIELD);
        map.put("pullStartedAt", PULL_STARTED_AT_FIELD);
        map.put("pullStoppedAt", PULL_STOPPED_AT_FIELD);
        map.put("executionStoppedAt", EXECUTION_STOPPED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitTaskStateChangeRequest, T> g) {
        return obj -> g.apply((SubmitTaskStateChangeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String task;
        private String status;
        private String reason;
        private List<ContainerStateChange> containers = DefaultSdkAutoConstructList.getInstance();
        private List<AttachmentStateChange> attachments = DefaultSdkAutoConstructList.getInstance();
        private List<ManagedAgentStateChange> managedAgents = DefaultSdkAutoConstructList.getInstance();
        private Instant pullStartedAt;
        private Instant pullStoppedAt;
        private Instant executionStoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitTaskStateChangeRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.task(model.task);
            this.status(model.status);
            this.reason(model.reason);
            this.containers(model.containers);
            this.attachments(model.attachments);
            this.managedAgents(model.managedAgents);
            this.pullStartedAt(model.pullStartedAt);
            this.pullStoppedAt(model.pullStoppedAt);
            this.executionStoppedAt(model.executionStoppedAt);
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getTask() {
            return this.task;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final List<ContainerStateChange.Builder> getContainers() {
            List<ContainerStateChange.Builder> result = ContainerStateChangesCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<ContainerStateChange.BuilderImpl> containers) {
            this.containers = ContainerStateChangesCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<ContainerStateChange> containers) {
            this.containers = ContainerStateChangesCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ContainerStateChange ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ContainerStateChange.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (ContainerStateChange)((ContainerStateChange.Builder)ContainerStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttachmentStateChange.Builder> getAttachments() {
            List<AttachmentStateChange.Builder> result = AttachmentStateChangesCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<AttachmentStateChange.BuilderImpl> attachments) {
            this.attachments = AttachmentStateChangesCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<AttachmentStateChange> attachments) {
            this.attachments = AttachmentStateChangesCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(AttachmentStateChange ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<AttachmentStateChange.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (AttachmentStateChange)((AttachmentStateChange.Builder)AttachmentStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ManagedAgentStateChange.Builder> getManagedAgents() {
            List<ManagedAgentStateChange.Builder> result = ManagedAgentStateChangesCopier.copyToBuilder(this.managedAgents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedAgents(Collection<ManagedAgentStateChange.BuilderImpl> managedAgents) {
            this.managedAgents = ManagedAgentStateChangesCopier.copyFromBuilder(managedAgents);
        }

        @Override
        public final Builder managedAgents(Collection<ManagedAgentStateChange> managedAgents) {
            this.managedAgents = ManagedAgentStateChangesCopier.copy(managedAgents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedAgents(ManagedAgentStateChange ... managedAgents) {
            this.managedAgents(Arrays.asList(managedAgents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedAgents(Consumer<ManagedAgentStateChange.Builder> ... managedAgents) {
            this.managedAgents(Stream.of(managedAgents).map(c -> (ManagedAgentStateChange)((ManagedAgentStateChange.Builder)ManagedAgentStateChange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getPullStartedAt() {
            return this.pullStartedAt;
        }

        public final void setPullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
        }

        @Override
        public final Builder pullStartedAt(Instant pullStartedAt) {
            this.pullStartedAt = pullStartedAt;
            return this;
        }

        public final Instant getPullStoppedAt() {
            return this.pullStoppedAt;
        }

        public final void setPullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
        }

        @Override
        public final Builder pullStoppedAt(Instant pullStoppedAt) {
            this.pullStoppedAt = pullStoppedAt;
            return this;
        }

        public final Instant getExecutionStoppedAt() {
            return this.executionStoppedAt;
        }

        public final void setExecutionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
        }

        @Override
        public final Builder executionStoppedAt(Instant executionStoppedAt) {
            this.executionStoppedAt = executionStoppedAt;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitTaskStateChangeRequest build() {
            return new SubmitTaskStateChangeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitTaskStateChangeRequest> {
        public Builder cluster(String var1);

        public Builder task(String var1);

        public Builder status(String var1);

        public Builder reason(String var1);

        public Builder containers(Collection<ContainerStateChange> var1);

        public Builder containers(ContainerStateChange ... var1);

        public Builder containers(Consumer<ContainerStateChange.Builder> ... var1);

        public Builder attachments(Collection<AttachmentStateChange> var1);

        public Builder attachments(AttachmentStateChange ... var1);

        public Builder attachments(Consumer<AttachmentStateChange.Builder> ... var1);

        public Builder managedAgents(Collection<ManagedAgentStateChange> var1);

        public Builder managedAgents(ManagedAgentStateChange ... var1);

        public Builder managedAgents(Consumer<ManagedAgentStateChange.Builder> ... var1);

        public Builder pullStartedAt(Instant var1);

        public Builder pullStoppedAt(Instant var1);

        public Builder executionStoppedAt(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

