/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for the task volume that was <code>configuredAtLaunch</code> that weren't set during
 * <code>RegisterTaskDef</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskVolumeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskVolumeConfiguration.Builder, TaskVolumeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TaskVolumeConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<TaskManagedEBSVolumeConfiguration> MANAGED_EBS_VOLUME_FIELD = SdkField
            .<TaskManagedEBSVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("managedEBSVolume")
            .getter(getter(TaskVolumeConfiguration::managedEBSVolume)).setter(setter(Builder::managedEBSVolume))
            .constructor(TaskManagedEBSVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedEBSVolume").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MANAGED_EBS_VOLUME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final TaskManagedEBSVolumeConfiguration managedEBSVolume;

    private TaskVolumeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.managedEBSVolume = builder.managedEBSVolume;
    }

    /**
     * <p>
     * The name of the volume. This value must match the volume name from the <code>Volume</code> object in the task
     * definition.
     * </p>
     * 
     * @return The name of the volume. This value must match the volume name from the <code>Volume</code> object in the
     *         task definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These settings
     * are used to create each Amazon EBS volume, with one volume created for each task. The Amazon EBS volumes are
     * visible in your account in the Amazon EC2 console once they are created.
     * </p>
     * 
     * @return The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
     *         settings are used to create each Amazon EBS volume, with one volume created for each task. The Amazon EBS
     *         volumes are visible in your account in the Amazon EC2 console once they are created.
     */
    public final TaskManagedEBSVolumeConfiguration managedEBSVolume() {
        return managedEBSVolume;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(managedEBSVolume());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskVolumeConfiguration)) {
            return false;
        }
        TaskVolumeConfiguration other = (TaskVolumeConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(managedEBSVolume(), other.managedEBSVolume());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskVolumeConfiguration").add("Name", name()).add("ManagedEBSVolume", managedEBSVolume())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "managedEBSVolume":
            return Optional.ofNullable(clazz.cast(managedEBSVolume()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("managedEBSVolume", MANAGED_EBS_VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskVolumeConfiguration, T> g) {
        return obj -> g.apply((TaskVolumeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskVolumeConfiguration> {
        /**
         * <p>
         * The name of the volume. This value must match the volume name from the <code>Volume</code> object in the task
         * definition.
         * </p>
         * 
         * @param name
         *        The name of the volume. This value must match the volume name from the <code>Volume</code> object in
         *        the task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
         * settings are used to create each Amazon EBS volume, with one volume created for each task. The Amazon EBS
         * volumes are visible in your account in the Amazon EC2 console once they are created.
         * </p>
         * 
         * @param managedEBSVolume
         *        The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
         *        settings are used to create each Amazon EBS volume, with one volume created for each task. The Amazon
         *        EBS volumes are visible in your account in the Amazon EC2 console once they are created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedEBSVolume(TaskManagedEBSVolumeConfiguration managedEBSVolume);

        /**
         * <p>
         * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf. These
         * settings are used to create each Amazon EBS volume, with one volume created for each task. The Amazon EBS
         * volumes are visible in your account in the Amazon EC2 console once they are created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TaskManagedEBSVolumeConfiguration.Builder} avoiding the need to create one manually via
         * {@link TaskManagedEBSVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskManagedEBSVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #managedEBSVolume(TaskManagedEBSVolumeConfiguration)}.
         * 
         * @param managedEBSVolume
         *        a consumer that will call methods on {@link TaskManagedEBSVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedEBSVolume(TaskManagedEBSVolumeConfiguration)
         */
        default Builder managedEBSVolume(Consumer<TaskManagedEBSVolumeConfiguration.Builder> managedEBSVolume) {
            return managedEBSVolume(TaskManagedEBSVolumeConfiguration.builder().applyMutation(managedEBSVolume).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private TaskManagedEBSVolumeConfiguration managedEBSVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskVolumeConfiguration model) {
            name(model.name);
            managedEBSVolume(model.managedEBSVolume);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TaskManagedEBSVolumeConfiguration.Builder getManagedEBSVolume() {
            return managedEBSVolume != null ? managedEBSVolume.toBuilder() : null;
        }

        public final void setManagedEBSVolume(TaskManagedEBSVolumeConfiguration.BuilderImpl managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume != null ? managedEBSVolume.build() : null;
        }

        @Override
        public final Builder managedEBSVolume(TaskManagedEBSVolumeConfiguration managedEBSVolume) {
            this.managedEBSVolume = managedEBSVolume;
            return this;
        }

        @Override
        public TaskVolumeConfiguration build() {
            return new TaskVolumeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
