/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The termination policy for the Amazon EBS volume when the task exits. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ebs-volumes.html#ebs-volume-types">Amazon ECS
 * volume termination policy</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskManagedEBSVolumeTerminationPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskManagedEBSVolumeTerminationPolicy.Builder, TaskManagedEBSVolumeTerminationPolicy> {
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deleteOnTermination").getter(getter(TaskManagedEBSVolumeTerminationPolicy::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteOnTermination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_ON_TERMINATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean deleteOnTermination;

    private TaskManagedEBSVolumeTerminationPolicy(BuilderImpl builder) {
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * Indicates whether the volume should be deleted on when the task stops. If a value of <code>true</code> is
     * specified, &#x2028;Amazon ECS deletes the Amazon EBS volume on your behalf when the task goes into the
     * <code>STOPPED</code> state. If no value is specified, the &#x2028;default value is <code>true</code> is used.
     * When set to <code>false</code>, Amazon ECS leaves the volume in your &#x2028;account.
     * </p>
     * 
     * @return Indicates whether the volume should be deleted on when the task stops. If a value of <code>true</code> is
     *         specified, &#x2028;Amazon ECS deletes the Amazon EBS volume on your behalf when the task goes into the
     *         <code>STOPPED</code> state. If no value is specified, the &#x2028;default value is <code>true</code> is
     *         used. When set to <code>false</code>, Amazon ECS leaves the volume in your &#x2028;account.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskManagedEBSVolumeTerminationPolicy)) {
            return false;
        }
        TaskManagedEBSVolumeTerminationPolicy other = (TaskManagedEBSVolumeTerminationPolicy) obj;
        return Objects.equals(deleteOnTermination(), other.deleteOnTermination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskManagedEBSVolumeTerminationPolicy").add("DeleteOnTermination", deleteOnTermination())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("deleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskManagedEBSVolumeTerminationPolicy, T> g) {
        return obj -> g.apply((TaskManagedEBSVolumeTerminationPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskManagedEBSVolumeTerminationPolicy> {
        /**
         * <p>
         * Indicates whether the volume should be deleted on when the task stops. If a value of <code>true</code> is
         * specified, &#x2028;Amazon ECS deletes the Amazon EBS volume on your behalf when the task goes into the
         * <code>STOPPED</code> state. If no value is specified, the &#x2028;default value is <code>true</code> is used.
         * When set to <code>false</code>, Amazon ECS leaves the volume in your &#x2028;account.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the volume should be deleted on when the task stops. If a value of <code>true</code>
         *        is specified, &#x2028;Amazon ECS deletes the Amazon EBS volume on your behalf when the task goes into
         *        the <code>STOPPED</code> state. If no value is specified, the &#x2028;default value is
         *        <code>true</code> is used. When set to <code>false</code>, Amazon ECS leaves the volume in your
         *        &#x2028;account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskManagedEBSVolumeTerminationPolicy model) {
            deleteOnTermination(model.deleteOnTermination);
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        @Override
        public TaskManagedEBSVolumeTerminationPolicy build() {
            return new TaskManagedEBSVolumeTerminationPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
