/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteExpressGatewayServiceResponse extends EcsResponse implements
        ToCopyableBuilder<DeleteExpressGatewayServiceResponse.Builder, DeleteExpressGatewayServiceResponse> {
    private static final SdkField<ECSExpressGatewayService> SERVICE_FIELD = SdkField
            .<ECSExpressGatewayService> builder(MarshallingType.SDK_POJO).memberName("service")
            .getter(getter(DeleteExpressGatewayServiceResponse::service)).setter(setter(Builder::service))
            .constructor(ECSExpressGatewayService::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ECSExpressGatewayService service;

    private DeleteExpressGatewayServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
    }

    /**
     * <p>
     * The full description of the deleted express service.
     * </p>
     * 
     * @return The full description of the deleted express service.
     */
    public final ECSExpressGatewayService service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteExpressGatewayServiceResponse)) {
            return false;
        }
        DeleteExpressGatewayServiceResponse other = (DeleteExpressGatewayServiceResponse) obj;
        return Objects.equals(service(), other.service());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteExpressGatewayServiceResponse").add("Service", service()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("service", SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteExpressGatewayServiceResponse, T> g) {
        return obj -> g.apply((DeleteExpressGatewayServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteExpressGatewayServiceResponse> {
        /**
         * <p>
         * The full description of the deleted express service.
         * </p>
         * 
         * @param service
         *        The full description of the deleted express service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(ECSExpressGatewayService service);

        /**
         * <p>
         * The full description of the deleted express service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ECSExpressGatewayService.Builder}
         * avoiding the need to create one manually via {@link ECSExpressGatewayService#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ECSExpressGatewayService.Builder#build()} is called immediately
         * and its result is passed to {@link #service(ECSExpressGatewayService)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link ECSExpressGatewayService.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(ECSExpressGatewayService)
         */
        default Builder service(Consumer<ECSExpressGatewayService.Builder> service) {
            return service(ECSExpressGatewayService.builder().applyMutation(service).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private ECSExpressGatewayService service;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteExpressGatewayServiceResponse model) {
            super(model);
            service(model.service);
        }

        public final ECSExpressGatewayService.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(ECSExpressGatewayService.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(ECSExpressGatewayService service) {
            this.service = service;
            return this;
        }

        @Override
        public DeleteExpressGatewayServiceResponse build() {
            return new DeleteExpressGatewayServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
