/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateExpressGatewayServiceRequest extends EcsRequest implements
        ToCopyableBuilder<CreateExpressGatewayServiceRequest.Builder, CreateExpressGatewayServiceRequest> {
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRoleArn").getter(getter(CreateExpressGatewayServiceRequest::executionRoleArn))
            .setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()).build();

    private static final SdkField<String> INFRASTRUCTURE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("infrastructureRoleArn").getter(getter(CreateExpressGatewayServiceRequest::infrastructureRoleArn))
            .setter(setter(Builder::infrastructureRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureRoleArn").build())
            .build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(CreateExpressGatewayServiceRequest::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(CreateExpressGatewayServiceRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthCheckPath").getter(getter(CreateExpressGatewayServiceRequest::healthCheckPath))
            .setter(setter(Builder::healthCheckPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckPath").build()).build();

    private static final SdkField<ExpressGatewayContainer> PRIMARY_CONTAINER_FIELD = SdkField
            .<ExpressGatewayContainer> builder(MarshallingType.SDK_POJO).memberName("primaryContainer")
            .getter(getter(CreateExpressGatewayServiceRequest::primaryContainer)).setter(setter(Builder::primaryContainer))
            .constructor(ExpressGatewayContainer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryContainer").build()).build();

    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRoleArn").getter(getter(CreateExpressGatewayServiceRequest::taskRoleArn))
            .setter(setter(Builder::taskRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()).build();

    private static final SdkField<ExpressGatewayServiceNetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<ExpressGatewayServiceNetworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkConfiguration")
            .getter(getter(CreateExpressGatewayServiceRequest::networkConfiguration))
            .setter(setter(Builder::networkConfiguration)).constructor(ExpressGatewayServiceNetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cpu")
            .getter(getter(CreateExpressGatewayServiceRequest::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("memory")
            .getter(getter(CreateExpressGatewayServiceRequest::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()).build();

    private static final SdkField<ExpressGatewayScalingTarget> SCALING_TARGET_FIELD = SdkField
            .<ExpressGatewayScalingTarget> builder(MarshallingType.SDK_POJO).memberName("scalingTarget")
            .getter(getter(CreateExpressGatewayServiceRequest::scalingTarget)).setter(setter(Builder::scalingTarget))
            .constructor(ExpressGatewayScalingTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalingTarget").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateExpressGatewayServiceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ROLE_ARN_FIELD,
            INFRASTRUCTURE_ROLE_ARN_FIELD, SERVICE_NAME_FIELD, CLUSTER_FIELD, HEALTH_CHECK_PATH_FIELD, PRIMARY_CONTAINER_FIELD,
            TASK_ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, CPU_FIELD, MEMORY_FIELD, SCALING_TARGET_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionRoleArn;

    private final String infrastructureRoleArn;

    private final String serviceName;

    private final String cluster;

    private final String healthCheckPath;

    private final ExpressGatewayContainer primaryContainer;

    private final String taskRoleArn;

    private final ExpressGatewayServiceNetworkConfiguration networkConfiguration;

    private final String cpu;

    private final String memory;

    private final ExpressGatewayScalingTarget scalingTarget;

    private final List<Tag> tags;

    private CreateExpressGatewayServiceRequest(BuilderImpl builder) {
        super(builder);
        this.executionRoleArn = builder.executionRoleArn;
        this.infrastructureRoleArn = builder.infrastructureRoleArn;
        this.serviceName = builder.serviceName;
        this.cluster = builder.cluster;
        this.healthCheckPath = builder.healthCheckPath;
        this.primaryContainer = builder.primaryContainer;
        this.taskRoleArn = builder.taskRoleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.scalingTarget = builder.scalingTarget;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission
     * to make Amazon Web Services API calls on your behalf. This role is required for Amazon ECS to pull container
     * images from Amazon ECR, send container logs to Amazon CloudWatch Logs, and retrieve sensitive data from Amazon
     * Web Services Systems Manager Parameter Store or Amazon Web Services Secrets Manager.
     * </p>
     * <p>
     * The execution role must include the <code>AmazonECSTaskExecutionRolePolicy</code> managed policy or equivalent
     * permissions. For Express services, this role is used during task startup and runtime for container management
     * operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
     *         permission to make Amazon Web Services API calls on your behalf. This role is required for Amazon ECS to
     *         pull container images from Amazon ECR, send container logs to Amazon CloudWatch Logs, and retrieve
     *         sensitive data from Amazon Web Services Systems Manager Parameter Store or Amazon Web Services Secrets
     *         Manager.</p>
     *         <p>
     *         The execution role must include the <code>AmazonECSTaskExecutionRolePolicy</code> managed policy or
     *         equivalent permissions. For Express services, this role is used during task startup and runtime for
     *         container management operations.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the infrastructure role that grants Amazon ECS permission to create and manage
     * Amazon Web Services resources on your behalf for the Express service. This role is used to provision and manage
     * Application Load Balancers, target groups, security groups, auto-scaling policies, and other Amazon Web Services
     * infrastructure components.
     * </p>
     * <p>
     * The infrastructure role must include permissions for Elastic Load Balancing, Application Auto Scaling, Amazon EC2
     * (for security groups), and other services required for managed infrastructure. This role is only used during
     * Express service creation, updates, and deletion operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the infrastructure role that grants Amazon ECS permission to create and
     *         manage Amazon Web Services resources on your behalf for the Express service. This role is used to
     *         provision and manage Application Load Balancers, target groups, security groups, auto-scaling policies,
     *         and other Amazon Web Services infrastructure components.</p>
     *         <p>
     *         The infrastructure role must include permissions for Elastic Load Balancing, Application Auto Scaling,
     *         Amazon EC2 (for security groups), and other services required for managed infrastructure. This role is
     *         only used during Express service creation, updates, and deletion operations.
     */
    public final String infrastructureRoleArn() {
        return infrastructureRoleArn;
    }

    /**
     * <p>
     * The name of the Express service. This name must be unique within the specified cluster and can contain up to 255
     * letters (uppercase and lowercase), numbers, underscores, and hyphens. The name is used to identify the service in
     * the Amazon ECS console and API operations.
     * </p>
     * <p>
     * If you don't specify a service name, Amazon ECS generates a unique name for the service. The service name becomes
     * part of the service ARN and cannot be changed after the service is created.
     * </p>
     * 
     * @return The name of the Express service. This name must be unique within the specified cluster and can contain up
     *         to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens. The name is used to identify
     *         the service in the Amazon ECS console and API operations.</p>
     *         <p>
     *         If you don't specify a service name, Amazon ECS generates a unique name for the service. The service name
     *         becomes part of the service ARN and cannot be changed after the service is created.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster on which to create the Express service. If you
     * do not specify a cluster, the <code>default</code> cluster is assumed.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster on which to create the Express service.
     *         If you do not specify a cluster, the <code>default</code> cluster is assumed.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The path on the container that the Application Load Balancer uses for health checks. This should be a valid HTTP
     * endpoint that returns a successful response (HTTP 200) when the application is healthy.
     * </p>
     * <p>
     * If not specified, the default health check path is <code>/ping</code>. The health check path must start with a
     * forward slash and can include query parameters. Examples: <code>/health</code>, <code>/api/status</code>,
     * <code>/ping?format=json</code>.
     * </p>
     * 
     * @return The path on the container that the Application Load Balancer uses for health checks. This should be a
     *         valid HTTP endpoint that returns a successful response (HTTP 200) when the application is healthy.</p>
     *         <p>
     *         If not specified, the default health check path is <code>/ping</code>. The health check path must start
     *         with a forward slash and can include query parameters. Examples: <code>/health</code>,
     *         <code>/api/status</code>, <code>/ping?format=json</code>.
     */
    public final String healthCheckPath() {
        return healthCheckPath;
    }

    /**
     * <p>
     * The primary container configuration for the Express service. This defines the main application container that
     * will receive traffic from the Application Load Balancer.
     * </p>
     * <p>
     * The primary container must specify at minimum a container image. You can also configure the container port
     * (defaults to 80), logging configuration, environment variables, secrets, and startup commands. The container
     * image can be from Amazon ECR, Docker Hub, or any other container registry accessible to your execution role.
     * </p>
     * 
     * @return The primary container configuration for the Express service. This defines the main application container
     *         that will receive traffic from the Application Load Balancer.</p>
     *         <p>
     *         The primary container must specify at minimum a container image. You can also configure the container
     *         port (defaults to 80), logging configuration, environment variables, secrets, and startup commands. The
     *         container image can be from Amazon ECR, Docker Hub, or any other container registry accessible to your
     *         execution role.
     */
    public final ExpressGatewayContainer primaryContainer() {
        return primaryContainer;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. This role allows your
     * application code to access other Amazon Web Services services securely.
     * </p>
     * <p>
     * The task role is different from the execution role. While the execution role is used by the Amazon ECS agent to
     * set up the task, the task role is used by your application code running inside the container to make Amazon Web
     * Services API calls. If your application doesn't need to access Amazon Web Services services, you can omit this
     * parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. This role allows
     *         your application code to access other Amazon Web Services services securely.</p>
     *         <p>
     *         The task role is different from the execution role. While the execution role is used by the Amazon ECS
     *         agent to set up the task, the task role is used by your application code running inside the container to
     *         make Amazon Web Services API calls. If your application doesn't need to access Amazon Web Services
     *         services, you can omit this parameter.
     */
    public final String taskRoleArn() {
        return taskRoleArn;
    }

    /**
     * <p>
     * The network configuration for the Express service tasks. This specifies the VPC subnets and security groups for
     * the tasks.
     * </p>
     * <p>
     * For Express services, you can specify custom security groups and subnets. If not provided, Amazon ECS will use
     * the default VPC configuration and create appropriate security groups automatically. The network configuration
     * determines how your service integrates with your VPC and what network access it has.
     * </p>
     * 
     * @return The network configuration for the Express service tasks. This specifies the VPC subnets and security
     *         groups for the tasks.</p>
     *         <p>
     *         For Express services, you can specify custom security groups and subnets. If not provided, Amazon ECS
     *         will use the default VPC configuration and create appropriate security groups automatically. The network
     *         configuration determines how your service integrates with your VPC and what network access it has.
     */
    public final ExpressGatewayServiceNetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The number of CPU units used by the task. This parameter determines the CPU allocation for each task in the
     * Express service. The default value for an Express service is 256 (.25 vCPU).
     * </p>
     * 
     * @return The number of CPU units used by the task. This parameter determines the CPU allocation for each task in
     *         the Express service. The default value for an Express service is 256 (.25 vCPU).
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The amount of memory (in MiB) used by the task. This parameter determines the memory allocation for each task in
     * the Express service. The default value for an express service is 512 MiB.
     * </p>
     * 
     * @return The amount of memory (in MiB) used by the task. This parameter determines the memory allocation for each
     *         task in the Express service. The default value for an express service is 512 MiB.
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The auto-scaling configuration for the Express service. This defines how the service automatically adjusts the
     * number of running tasks based on demand.
     * </p>
     * <p>
     * You can specify the minimum and maximum number of tasks, the scaling metric (CPU utilization, memory utilization,
     * or request count per target), and the target value for the metric. If not specified, the default target value for
     * an Express service is 60.
     * </p>
     * 
     * @return The auto-scaling configuration for the Express service. This defines how the service automatically
     *         adjusts the number of running tasks based on demand.</p>
     *         <p>
     *         You can specify the minimum and maximum number of tasks, the scaling metric (CPU utilization, memory
     *         utilization, or request count per target), and the target value for the metric. If not specified, the
     *         default target value for an Express service is 60.
     */
    public final ExpressGatewayScalingTarget scalingTarget() {
        return scalingTarget;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the Express service to help categorize and organize it. Each tag consists of a key
     * and an optional value. You can apply up to 50 tags to a service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The metadata that you apply to the Express service to help categorize and organize it. Each tag consists
     *         of a key and an optional value. You can apply up to 50 tags to a service.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPath());
        hashCode = 31 * hashCode + Objects.hashCode(primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(scalingTarget());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExpressGatewayServiceRequest)) {
            return false;
        }
        CreateExpressGatewayServiceRequest other = (CreateExpressGatewayServiceRequest) obj;
        return Objects.equals(executionRoleArn(), other.executionRoleArn())
                && Objects.equals(infrastructureRoleArn(), other.infrastructureRoleArn())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(cluster(), other.cluster())
                && Objects.equals(healthCheckPath(), other.healthCheckPath())
                && Objects.equals(primaryContainer(), other.primaryContainer())
                && Objects.equals(taskRoleArn(), other.taskRoleArn())
                && Objects.equals(networkConfiguration(), other.networkConfiguration()) && Objects.equals(cpu(), other.cpu())
                && Objects.equals(memory(), other.memory()) && Objects.equals(scalingTarget(), other.scalingTarget())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateExpressGatewayServiceRequest").add("ExecutionRoleArn", executionRoleArn())
                .add("InfrastructureRoleArn", infrastructureRoleArn()).add("ServiceName", serviceName())
                .add("Cluster", cluster()).add("HealthCheckPath", healthCheckPath()).add("PrimaryContainer", primaryContainer())
                .add("TaskRoleArn", taskRoleArn()).add("NetworkConfiguration", networkConfiguration()).add("Cpu", cpu())
                .add("Memory", memory()).add("ScalingTarget", scalingTarget()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "infrastructureRoleArn":
            return Optional.ofNullable(clazz.cast(infrastructureRoleArn()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "healthCheckPath":
            return Optional.ofNullable(clazz.cast(healthCheckPath()));
        case "primaryContainer":
            return Optional.ofNullable(clazz.cast(primaryContainer()));
        case "taskRoleArn":
            return Optional.ofNullable(clazz.cast(taskRoleArn()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "scalingTarget":
            return Optional.ofNullable(clazz.cast(scalingTarget()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("infrastructureRoleArn", INFRASTRUCTURE_ROLE_ARN_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("cluster", CLUSTER_FIELD);
        map.put("healthCheckPath", HEALTH_CHECK_PATH_FIELD);
        map.put("primaryContainer", PRIMARY_CONTAINER_FIELD);
        map.put("taskRoleArn", TASK_ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("memory", MEMORY_FIELD);
        map.put("scalingTarget", SCALING_TARGET_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExpressGatewayServiceRequest, T> g) {
        return obj -> g.apply((CreateExpressGatewayServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateExpressGatewayServiceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
         * permission to make Amazon Web Services API calls on your behalf. This role is required for Amazon ECS to pull
         * container images from Amazon ECR, send container logs to Amazon CloudWatch Logs, and retrieve sensitive data
         * from Amazon Web Services Systems Manager Parameter Store or Amazon Web Services Secrets Manager.
         * </p>
         * <p>
         * The execution role must include the <code>AmazonECSTaskExecutionRolePolicy</code> managed policy or
         * equivalent permissions. For Express services, this role is used during task startup and runtime for container
         * management operations.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent
         *        permission to make Amazon Web Services API calls on your behalf. This role is required for Amazon ECS
         *        to pull container images from Amazon ECR, send container logs to Amazon CloudWatch Logs, and retrieve
         *        sensitive data from Amazon Web Services Systems Manager Parameter Store or Amazon Web Services Secrets
         *        Manager.</p>
         *        <p>
         *        The execution role must include the <code>AmazonECSTaskExecutionRolePolicy</code> managed policy or
         *        equivalent permissions. For Express services, this role is used during task startup and runtime for
         *        container management operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the infrastructure role that grants Amazon ECS permission to create and
         * manage Amazon Web Services resources on your behalf for the Express service. This role is used to provision
         * and manage Application Load Balancers, target groups, security groups, auto-scaling policies, and other
         * Amazon Web Services infrastructure components.
         * </p>
         * <p>
         * The infrastructure role must include permissions for Elastic Load Balancing, Application Auto Scaling, Amazon
         * EC2 (for security groups), and other services required for managed infrastructure. This role is only used
         * during Express service creation, updates, and deletion operations.
         * </p>
         * 
         * @param infrastructureRoleArn
         *        The Amazon Resource Name (ARN) of the infrastructure role that grants Amazon ECS permission to create
         *        and manage Amazon Web Services resources on your behalf for the Express service. This role is used to
         *        provision and manage Application Load Balancers, target groups, security groups, auto-scaling
         *        policies, and other Amazon Web Services infrastructure components.</p>
         *        <p>
         *        The infrastructure role must include permissions for Elastic Load Balancing, Application Auto Scaling,
         *        Amazon EC2 (for security groups), and other services required for managed infrastructure. This role is
         *        only used during Express service creation, updates, and deletion operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureRoleArn(String infrastructureRoleArn);

        /**
         * <p>
         * The name of the Express service. This name must be unique within the specified cluster and can contain up to
         * 255 letters (uppercase and lowercase), numbers, underscores, and hyphens. The name is used to identify the
         * service in the Amazon ECS console and API operations.
         * </p>
         * <p>
         * If you don't specify a service name, Amazon ECS generates a unique name for the service. The service name
         * becomes part of the service ARN and cannot be changed after the service is created.
         * </p>
         * 
         * @param serviceName
         *        The name of the Express service. This name must be unique within the specified cluster and can contain
         *        up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens. The name is used to
         *        identify the service in the Amazon ECS console and API operations.</p>
         *        <p>
         *        If you don't specify a service name, Amazon ECS generates a unique name for the service. The service
         *        name becomes part of the service ARN and cannot be changed after the service is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster on which to create the Express service. If
         * you do not specify a cluster, the <code>default</code> cluster is assumed.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster on which to create the Express
         *        service. If you do not specify a cluster, the <code>default</code> cluster is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The path on the container that the Application Load Balancer uses for health checks. This should be a valid
         * HTTP endpoint that returns a successful response (HTTP 200) when the application is healthy.
         * </p>
         * <p>
         * If not specified, the default health check path is <code>/ping</code>. The health check path must start with
         * a forward slash and can include query parameters. Examples: <code>/health</code>, <code>/api/status</code>,
         * <code>/ping?format=json</code>.
         * </p>
         * 
         * @param healthCheckPath
         *        The path on the container that the Application Load Balancer uses for health checks. This should be a
         *        valid HTTP endpoint that returns a successful response (HTTP 200) when the application is healthy.</p>
         *        <p>
         *        If not specified, the default health check path is <code>/ping</code>. The health check path must
         *        start with a forward slash and can include query parameters. Examples: <code>/health</code>,
         *        <code>/api/status</code>, <code>/ping?format=json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPath(String healthCheckPath);

        /**
         * <p>
         * The primary container configuration for the Express service. This defines the main application container that
         * will receive traffic from the Application Load Balancer.
         * </p>
         * <p>
         * The primary container must specify at minimum a container image. You can also configure the container port
         * (defaults to 80), logging configuration, environment variables, secrets, and startup commands. The container
         * image can be from Amazon ECR, Docker Hub, or any other container registry accessible to your execution role.
         * </p>
         * 
         * @param primaryContainer
         *        The primary container configuration for the Express service. This defines the main application
         *        container that will receive traffic from the Application Load Balancer.</p>
         *        <p>
         *        The primary container must specify at minimum a container image. You can also configure the container
         *        port (defaults to 80), logging configuration, environment variables, secrets, and startup commands.
         *        The container image can be from Amazon ECR, Docker Hub, or any other container registry accessible to
         *        your execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryContainer(ExpressGatewayContainer primaryContainer);

        /**
         * <p>
         * The primary container configuration for the Express service. This defines the main application container that
         * will receive traffic from the Application Load Balancer.
         * </p>
         * <p>
         * The primary container must specify at minimum a container image. You can also configure the container port
         * (defaults to 80), logging configuration, environment variables, secrets, and startup commands. The container
         * image can be from Amazon ECR, Docker Hub, or any other container registry accessible to your execution role.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayContainer.Builder} avoiding
         * the need to create one manually via {@link ExpressGatewayContainer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayContainer.Builder#build()} is called immediately
         * and its result is passed to {@link #primaryContainer(ExpressGatewayContainer)}.
         * 
         * @param primaryContainer
         *        a consumer that will call methods on {@link ExpressGatewayContainer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryContainer(ExpressGatewayContainer)
         */
        default Builder primaryContainer(Consumer<ExpressGatewayContainer.Builder> primaryContainer) {
            return primaryContainer(ExpressGatewayContainer.builder().applyMutation(primaryContainer).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. This role allows your
         * application code to access other Amazon Web Services services securely.
         * </p>
         * <p>
         * The task role is different from the execution role. While the execution role is used by the Amazon ECS agent
         * to set up the task, the task role is used by your application code running inside the container to make
         * Amazon Web Services API calls. If your application doesn't need to access Amazon Web Services services, you
         * can omit this parameter.
         * </p>
         * 
         * @param taskRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. This role
         *        allows your application code to access other Amazon Web Services services securely.</p>
         *        <p>
         *        The task role is different from the execution role. While the execution role is used by the Amazon ECS
         *        agent to set up the task, the task role is used by your application code running inside the container
         *        to make Amazon Web Services API calls. If your application doesn't need to access Amazon Web Services
         *        services, you can omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRoleArn(String taskRoleArn);

        /**
         * <p>
         * The network configuration for the Express service tasks. This specifies the VPC subnets and security groups
         * for the tasks.
         * </p>
         * <p>
         * For Express services, you can specify custom security groups and subnets. If not provided, Amazon ECS will
         * use the default VPC configuration and create appropriate security groups automatically. The network
         * configuration determines how your service integrates with your VPC and what network access it has.
         * </p>
         * 
         * @param networkConfiguration
         *        The network configuration for the Express service tasks. This specifies the VPC subnets and security
         *        groups for the tasks.</p>
         *        <p>
         *        For Express services, you can specify custom security groups and subnets. If not provided, Amazon ECS
         *        will use the default VPC configuration and create appropriate security groups automatically. The
         *        network configuration determines how your service integrates with your VPC and what network access it
         *        has.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The network configuration for the Express service tasks. This specifies the VPC subnets and security groups
         * for the tasks.
         * </p>
         * <p>
         * For Express services, you can specify custom security groups and subnets. If not provided, Amazon ECS will
         * use the default VPC configuration and create appropriate security groups automatically. The network
         * configuration determines how your service integrates with your VPC and what network access it has.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ExpressGatewayServiceNetworkConfiguration.Builder} avoiding the need to create one manually via
         * {@link ExpressGatewayServiceNetworkConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayServiceNetworkConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkConfiguration(ExpressGatewayServiceNetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link ExpressGatewayServiceNetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(ExpressGatewayServiceNetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<ExpressGatewayServiceNetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(ExpressGatewayServiceNetworkConfiguration.builder().applyMutation(networkConfiguration)
                    .build());
        }

        /**
         * <p>
         * The number of CPU units used by the task. This parameter determines the CPU allocation for each task in the
         * Express service. The default value for an Express service is 256 (.25 vCPU).
         * </p>
         * 
         * @param cpu
         *        The number of CPU units used by the task. This parameter determines the CPU allocation for each task
         *        in the Express service. The default value for an Express service is 256 (.25 vCPU).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The amount of memory (in MiB) used by the task. This parameter determines the memory allocation for each task
         * in the Express service. The default value for an express service is 512 MiB.
         * </p>
         * 
         * @param memory
         *        The amount of memory (in MiB) used by the task. This parameter determines the memory allocation for
         *        each task in the Express service. The default value for an express service is 512 MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The auto-scaling configuration for the Express service. This defines how the service automatically adjusts
         * the number of running tasks based on demand.
         * </p>
         * <p>
         * You can specify the minimum and maximum number of tasks, the scaling metric (CPU utilization, memory
         * utilization, or request count per target), and the target value for the metric. If not specified, the default
         * target value for an Express service is 60.
         * </p>
         * 
         * @param scalingTarget
         *        The auto-scaling configuration for the Express service. This defines how the service automatically
         *        adjusts the number of running tasks based on demand.</p>
         *        <p>
         *        You can specify the minimum and maximum number of tasks, the scaling metric (CPU utilization, memory
         *        utilization, or request count per target), and the target value for the metric. If not specified, the
         *        default target value for an Express service is 60.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget);

        /**
         * <p>
         * The auto-scaling configuration for the Express service. This defines how the service automatically adjusts
         * the number of running tasks based on demand.
         * </p>
         * <p>
         * You can specify the minimum and maximum number of tasks, the scaling metric (CPU utilization, memory
         * utilization, or request count per target), and the target value for the metric. If not specified, the default
         * target value for an Express service is 60.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExpressGatewayScalingTarget.Builder}
         * avoiding the need to create one manually via {@link ExpressGatewayScalingTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExpressGatewayScalingTarget.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingTarget(ExpressGatewayScalingTarget)}.
         * 
         * @param scalingTarget
         *        a consumer that will call methods on {@link ExpressGatewayScalingTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingTarget(ExpressGatewayScalingTarget)
         */
        default Builder scalingTarget(Consumer<ExpressGatewayScalingTarget.Builder> scalingTarget) {
            return scalingTarget(ExpressGatewayScalingTarget.builder().applyMutation(scalingTarget).build());
        }

        /**
         * <p>
         * The metadata that you apply to the Express service to help categorize and organize it. Each tag consists of a
         * key and an optional value. You can apply up to 50 tags to a service.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the Express service to help categorize and organize it. Each tag
         *        consists of a key and an optional value. You can apply up to 50 tags to a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the Express service to help categorize and organize it. Each tag consists of a
         * key and an optional value. You can apply up to 50 tags to a service.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the Express service to help categorize and organize it. Each tag
         *        consists of a key and an optional value. You can apply up to 50 tags to a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the Express service to help categorize and organize it. Each tag consists of a
         * key and an optional value. You can apply up to 50 tags to a service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ecs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ecs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ecs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String executionRoleArn;

        private String infrastructureRoleArn;

        private String serviceName;

        private String cluster;

        private String healthCheckPath;

        private ExpressGatewayContainer primaryContainer;

        private String taskRoleArn;

        private ExpressGatewayServiceNetworkConfiguration networkConfiguration;

        private String cpu;

        private String memory;

        private ExpressGatewayScalingTarget scalingTarget;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExpressGatewayServiceRequest model) {
            super(model);
            executionRoleArn(model.executionRoleArn);
            infrastructureRoleArn(model.infrastructureRoleArn);
            serviceName(model.serviceName);
            cluster(model.cluster);
            healthCheckPath(model.healthCheckPath);
            primaryContainer(model.primaryContainer);
            taskRoleArn(model.taskRoleArn);
            networkConfiguration(model.networkConfiguration);
            cpu(model.cpu);
            memory(model.memory);
            scalingTarget(model.scalingTarget);
            tags(model.tags);
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getInfrastructureRoleArn() {
            return infrastructureRoleArn;
        }

        public final void setInfrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
        }

        @Override
        public final Builder infrastructureRoleArn(String infrastructureRoleArn) {
            this.infrastructureRoleArn = infrastructureRoleArn;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final String getHealthCheckPath() {
            return healthCheckPath;
        }

        public final void setHealthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
        }

        @Override
        public final Builder healthCheckPath(String healthCheckPath) {
            this.healthCheckPath = healthCheckPath;
            return this;
        }

        public final ExpressGatewayContainer.Builder getPrimaryContainer() {
            return primaryContainer != null ? primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ExpressGatewayContainer.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ExpressGatewayContainer primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final String getTaskRoleArn() {
            return taskRoleArn;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final ExpressGatewayServiceNetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(ExpressGatewayServiceNetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(ExpressGatewayServiceNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final ExpressGatewayScalingTarget.Builder getScalingTarget() {
            return scalingTarget != null ? scalingTarget.toBuilder() : null;
        }

        public final void setScalingTarget(ExpressGatewayScalingTarget.BuilderImpl scalingTarget) {
            this.scalingTarget = scalingTarget != null ? scalingTarget.build() : null;
        }

        @Override
        public final Builder scalingTarget(ExpressGatewayScalingTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExpressGatewayServiceRequest build() {
            return new CreateExpressGatewayServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
