/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for a canary deployment strategy that shifts a fixed percentage of traffic to the new service revision,
 * waits for a specified bake time, then shifts the remaining traffic.
 * </p>
 * <p>
 * This is only valid when you run <code>CreateService</code> or <code>UpdateService</code> with
 * <code>deploymentController</code> set to <code>ECS</code> and a <code>deploymentConfiguration</code> with a strategy
 * set to <code>CANARY</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CanaryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CanaryConfiguration.Builder, CanaryConfiguration> {
    private static final SdkField<Double> CANARY_PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("canaryPercent").getter(getter(CanaryConfiguration::canaryPercent))
            .setter(setter(Builder::canaryPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryPercent").build()).build();

    private static final SdkField<Integer> CANARY_BAKE_TIME_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("canaryBakeTimeInMinutes")
            .getter(getter(CanaryConfiguration::canaryBakeTimeInMinutes)).setter(setter(Builder::canaryBakeTimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryBakeTimeInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_PERCENT_FIELD,
            CANARY_BAKE_TIME_IN_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double canaryPercent;

    private final Integer canaryBakeTimeInMinutes;

    private CanaryConfiguration(BuilderImpl builder) {
        this.canaryPercent = builder.canaryPercent;
        this.canaryBakeTimeInMinutes = builder.canaryBakeTimeInMinutes;
    }

    /**
     * <p>
     * The percentage of production traffic to shift to the new service revision during the canary phase. Valid values
     * are multiples of 0.1 from 0.1 to 100.0. The default value is 5.0.
     * </p>
     * 
     * @return The percentage of production traffic to shift to the new service revision during the canary phase. Valid
     *         values are multiples of 0.1 from 0.1 to 100.0. The default value is 5.0.
     */
    public final Double canaryPercent() {
        return canaryPercent;
    }

    /**
     * <p>
     * The amount of time in minutes to wait during the canary phase before shifting the remaining production traffic to
     * the new service revision. Valid values are 0 to 1440 minutes (24 hours). The default value is 10.
     * </p>
     * 
     * @return The amount of time in minutes to wait during the canary phase before shifting the remaining production
     *         traffic to the new service revision. Valid values are 0 to 1440 minutes (24 hours). The default value is
     *         10.
     */
    public final Integer canaryBakeTimeInMinutes() {
        return canaryBakeTimeInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(canaryPercent());
        hashCode = 31 * hashCode + Objects.hashCode(canaryBakeTimeInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryConfiguration)) {
            return false;
        }
        CanaryConfiguration other = (CanaryConfiguration) obj;
        return Objects.equals(canaryPercent(), other.canaryPercent())
                && Objects.equals(canaryBakeTimeInMinutes(), other.canaryBakeTimeInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CanaryConfiguration").add("CanaryPercent", canaryPercent())
                .add("CanaryBakeTimeInMinutes", canaryBakeTimeInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "canaryPercent":
            return Optional.ofNullable(clazz.cast(canaryPercent()));
        case "canaryBakeTimeInMinutes":
            return Optional.ofNullable(clazz.cast(canaryBakeTimeInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("canaryPercent", CANARY_PERCENT_FIELD);
        map.put("canaryBakeTimeInMinutes", CANARY_BAKE_TIME_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryConfiguration, T> g) {
        return obj -> g.apply((CanaryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CanaryConfiguration> {
        /**
         * <p>
         * The percentage of production traffic to shift to the new service revision during the canary phase. Valid
         * values are multiples of 0.1 from 0.1 to 100.0. The default value is 5.0.
         * </p>
         * 
         * @param canaryPercent
         *        The percentage of production traffic to shift to the new service revision during the canary phase.
         *        Valid values are multiples of 0.1 from 0.1 to 100.0. The default value is 5.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryPercent(Double canaryPercent);

        /**
         * <p>
         * The amount of time in minutes to wait during the canary phase before shifting the remaining production
         * traffic to the new service revision. Valid values are 0 to 1440 minutes (24 hours). The default value is 10.
         * </p>
         * 
         * @param canaryBakeTimeInMinutes
         *        The amount of time in minutes to wait during the canary phase before shifting the remaining production
         *        traffic to the new service revision. Valid values are 0 to 1440 minutes (24 hours). The default value
         *        is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder canaryBakeTimeInMinutes(Integer canaryBakeTimeInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Double canaryPercent;

        private Integer canaryBakeTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryConfiguration model) {
            canaryPercent(model.canaryPercent);
            canaryBakeTimeInMinutes(model.canaryBakeTimeInMinutes);
        }

        public final Double getCanaryPercent() {
            return canaryPercent;
        }

        public final void setCanaryPercent(Double canaryPercent) {
            this.canaryPercent = canaryPercent;
        }

        @Override
        public final Builder canaryPercent(Double canaryPercent) {
            this.canaryPercent = canaryPercent;
            return this;
        }

        public final Integer getCanaryBakeTimeInMinutes() {
            return canaryBakeTimeInMinutes;
        }

        public final void setCanaryBakeTimeInMinutes(Integer canaryBakeTimeInMinutes) {
            this.canaryBakeTimeInMinutes = canaryBakeTimeInMinutes;
        }

        @Override
        public final Builder canaryBakeTimeInMinutes(Integer canaryBakeTimeInMinutes) {
            this.canaryBakeTimeInMinutes = canaryBakeTimeInMinutes;
            return this;
        }

        @Override
        public CanaryConfiguration build() {
            return new CanaryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
