/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.TransportProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkBinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkBinding> {
    private static final SdkField<String> BIND_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bindIP").getter(NetworkBinding.getter(NetworkBinding::bindIP)).setter(NetworkBinding.setter(Builder::bindIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bindIP").build()}).build();
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("containerPort").getter(NetworkBinding.getter(NetworkBinding::containerPort)).setter(NetworkBinding.setter(Builder::containerPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPort").build()}).build();
    private static final SdkField<Integer> HOST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("hostPort").getter(NetworkBinding.getter(NetworkBinding::hostPort)).setter(NetworkBinding.setter(Builder::hostPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(NetworkBinding.getter(NetworkBinding::protocolAsString)).setter(NetworkBinding.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> CONTAINER_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerPortRange").getter(NetworkBinding.getter(NetworkBinding::containerPortRange)).setter(NetworkBinding.setter(Builder::containerPortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPortRange").build()}).build();
    private static final SdkField<String> HOST_PORT_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostPortRange").getter(NetworkBinding.getter(NetworkBinding::hostPortRange)).setter(NetworkBinding.setter(Builder::hostPortRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostPortRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIND_IP_FIELD, CONTAINER_PORT_FIELD, HOST_PORT_FIELD, PROTOCOL_FIELD, CONTAINER_PORT_RANGE_FIELD, HOST_PORT_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkBinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bindIP;
    private final Integer containerPort;
    private final Integer hostPort;
    private final String protocol;
    private final String containerPortRange;
    private final String hostPortRange;

    private NetworkBinding(BuilderImpl builder) {
        this.bindIP = builder.bindIP;
        this.containerPort = builder.containerPort;
        this.hostPort = builder.hostPort;
        this.protocol = builder.protocol;
        this.containerPortRange = builder.containerPortRange;
        this.hostPortRange = builder.hostPortRange;
    }

    public final String bindIP() {
        return this.bindIP;
    }

    public final Integer containerPort() {
        return this.containerPort;
    }

    public final Integer hostPort() {
        return this.hostPort;
    }

    public final TransportProtocol protocol() {
        return TransportProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String containerPortRange() {
        return this.containerPortRange;
    }

    public final String hostPortRange() {
        return this.hostPortRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bindIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostPortRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkBinding)) {
            return false;
        }
        NetworkBinding other = (NetworkBinding)obj;
        return Objects.equals(this.bindIP(), other.bindIP()) && Objects.equals(this.containerPort(), other.containerPort()) && Objects.equals(this.hostPort(), other.hostPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.containerPortRange(), other.containerPortRange()) && Objects.equals(this.hostPortRange(), other.hostPortRange());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkBinding").add("BindIP", (Object)this.bindIP()).add("ContainerPort", (Object)this.containerPort()).add("HostPort", (Object)this.hostPort()).add("Protocol", (Object)this.protocolAsString()).add("ContainerPortRange", (Object)this.containerPortRange()).add("HostPortRange", (Object)this.hostPortRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bindIP": {
                return Optional.ofNullable(clazz.cast(this.bindIP()));
            }
            case "containerPort": {
                return Optional.ofNullable(clazz.cast(this.containerPort()));
            }
            case "hostPort": {
                return Optional.ofNullable(clazz.cast(this.hostPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "containerPortRange": {
                return Optional.ofNullable(clazz.cast(this.containerPortRange()));
            }
            case "hostPortRange": {
                return Optional.ofNullable(clazz.cast(this.hostPortRange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bindIP", BIND_IP_FIELD);
        map.put("containerPort", CONTAINER_PORT_FIELD);
        map.put("hostPort", HOST_PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("containerPortRange", CONTAINER_PORT_RANGE_FIELD);
        map.put("hostPortRange", HOST_PORT_RANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkBinding, T> g) {
        return obj -> g.apply((NetworkBinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bindIP;
        private Integer containerPort;
        private Integer hostPort;
        private String protocol;
        private String containerPortRange;
        private String hostPortRange;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkBinding model) {
            this.bindIP(model.bindIP);
            this.containerPort(model.containerPort);
            this.hostPort(model.hostPort);
            this.protocol(model.protocol);
            this.containerPortRange(model.containerPortRange);
            this.hostPortRange(model.hostPortRange);
        }

        public final String getBindIP() {
            return this.bindIP;
        }

        public final void setBindIP(String bindIP) {
            this.bindIP = bindIP;
        }

        @Override
        public final Builder bindIP(String bindIP) {
            this.bindIP = bindIP;
            return this;
        }

        public final Integer getContainerPort() {
            return this.containerPort;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final Integer getHostPort() {
            return this.hostPort;
        }

        public final void setHostPort(Integer hostPort) {
            this.hostPort = hostPort;
        }

        @Override
        public final Builder hostPort(Integer hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TransportProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getContainerPortRange() {
            return this.containerPortRange;
        }

        public final void setContainerPortRange(String containerPortRange) {
            this.containerPortRange = containerPortRange;
        }

        @Override
        public final Builder containerPortRange(String containerPortRange) {
            this.containerPortRange = containerPortRange;
            return this;
        }

        public final String getHostPortRange() {
            return this.hostPortRange;
        }

        public final void setHostPortRange(String hostPortRange) {
            this.hostPortRange = hostPortRange;
        }

        @Override
        public final Builder hostPortRange(String hostPortRange) {
            this.hostPortRange = hostPortRange;
            return this;
        }

        public NetworkBinding build() {
            return new NetworkBinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkBinding> {
        public Builder bindIP(String var1);

        public Builder containerPort(Integer var1);

        public Builder hostPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(TransportProtocol var1);

        public Builder containerPortRange(String var1);

        public Builder hostPortRange(String var1);
    }
}

