/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeoutConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeoutConfiguration> {
    private static final SdkField<Integer> IDLE_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleTimeoutSeconds").getter(TimeoutConfiguration.getter(TimeoutConfiguration::idleTimeoutSeconds)).setter(TimeoutConfiguration.setter(Builder::idleTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleTimeoutSeconds").build()}).build();
    private static final SdkField<Integer> PER_REQUEST_TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("perRequestTimeoutSeconds").getter(TimeoutConfiguration.getter(TimeoutConfiguration::perRequestTimeoutSeconds)).setter(TimeoutConfiguration.setter(Builder::perRequestTimeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("perRequestTimeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDLE_TIMEOUT_SECONDS_FIELD, PER_REQUEST_TIMEOUT_SECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimeoutConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer idleTimeoutSeconds;
    private final Integer perRequestTimeoutSeconds;

    private TimeoutConfiguration(BuilderImpl builder) {
        this.idleTimeoutSeconds = builder.idleTimeoutSeconds;
        this.perRequestTimeoutSeconds = builder.perRequestTimeoutSeconds;
    }

    public final Integer idleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public final Integer perRequestTimeoutSeconds() {
        return this.perRequestTimeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.perRequestTimeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeoutConfiguration)) {
            return false;
        }
        TimeoutConfiguration other = (TimeoutConfiguration)obj;
        return Objects.equals(this.idleTimeoutSeconds(), other.idleTimeoutSeconds()) && Objects.equals(this.perRequestTimeoutSeconds(), other.perRequestTimeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"TimeoutConfiguration").add("IdleTimeoutSeconds", (Object)this.idleTimeoutSeconds()).add("PerRequestTimeoutSeconds", (Object)this.perRequestTimeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "idleTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleTimeoutSeconds()));
            }
            case "perRequestTimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.perRequestTimeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("idleTimeoutSeconds", IDLE_TIMEOUT_SECONDS_FIELD);
        map.put("perRequestTimeoutSeconds", PER_REQUEST_TIMEOUT_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeoutConfiguration, T> g) {
        return obj -> g.apply((TimeoutConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer idleTimeoutSeconds;
        private Integer perRequestTimeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeoutConfiguration model) {
            this.idleTimeoutSeconds(model.idleTimeoutSeconds);
            this.perRequestTimeoutSeconds(model.perRequestTimeoutSeconds);
        }

        public final Integer getIdleTimeoutSeconds() {
            return this.idleTimeoutSeconds;
        }

        public final void setIdleTimeoutSeconds(Integer idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
        }

        @Override
        public final Builder idleTimeoutSeconds(Integer idleTimeoutSeconds) {
            this.idleTimeoutSeconds = idleTimeoutSeconds;
            return this;
        }

        public final Integer getPerRequestTimeoutSeconds() {
            return this.perRequestTimeoutSeconds;
        }

        public final void setPerRequestTimeoutSeconds(Integer perRequestTimeoutSeconds) {
            this.perRequestTimeoutSeconds = perRequestTimeoutSeconds;
        }

        @Override
        public final Builder perRequestTimeoutSeconds(Integer perRequestTimeoutSeconds) {
            this.perRequestTimeoutSeconds = perRequestTimeoutSeconds;
            return this;
        }

        public TimeoutConfiguration build() {
            return new TimeoutConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeoutConfiguration> {
        public Builder idleTimeoutSeconds(Integer var1);

        public Builder perRequestTimeoutSeconds(Integer var1);
    }
}

