/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.LaunchType;
import software.amazon.awssdk.services.ecs.model.NetworkConfiguration;
import software.amazon.awssdk.services.ecs.model.PlacementConstraint;
import software.amazon.awssdk.services.ecs.model.PlacementConstraintsCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategiesCopier;
import software.amazon.awssdk.services.ecs.model.PlacementStrategy;
import software.amazon.awssdk.services.ecs.model.PropagateTags;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.services.ecs.model.TaskOverride;
import software.amazon.awssdk.services.ecs.model.TaskVolumeConfiguration;
import software.amazon.awssdk.services.ecs.model.TaskVolumeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunTaskRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, RunTaskRequest> {
    private static final SdkField<List<CapacityProviderStrategyItem>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviderStrategy").getter(RunTaskRequest.getter(RunTaskRequest::capacityProviderStrategy)).setter(RunTaskRequest.setter(Builder::capacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(RunTaskRequest.getter(RunTaskRequest::cluster)).setter(RunTaskRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(RunTaskRequest.getter(RunTaskRequest::count)).setter(RunTaskRequest.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableECSManagedTags").getter(RunTaskRequest.getter(RunTaskRequest::enableECSManagedTags)).setter(RunTaskRequest.setter(Builder::enableECSManagedTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build()}).build();
    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableExecuteCommand").getter(RunTaskRequest.getter(RunTaskRequest::enableExecuteCommand)).setter(RunTaskRequest.setter(Builder::enableExecuteCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableExecuteCommand").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(RunTaskRequest.getter(RunTaskRequest::group)).setter(RunTaskRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchType").getter(RunTaskRequest.getter(RunTaskRequest::launchTypeAsString)).setter(RunTaskRequest.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(RunTaskRequest.getter(RunTaskRequest::networkConfiguration)).setter(RunTaskRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<TaskOverride> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("overrides").getter(RunTaskRequest.getter(RunTaskRequest::overrides)).setter(RunTaskRequest.setter(Builder::overrides)).constructor(TaskOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrides").build()}).build();
    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementConstraints").getter(RunTaskRequest.getter(RunTaskRequest::placementConstraints)).setter(RunTaskRequest.setter(Builder::placementConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("placementStrategy").getter(RunTaskRequest.getter(RunTaskRequest::placementStrategy)).setter(RunTaskRequest.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlacementStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platformVersion").getter(RunTaskRequest.getter(RunTaskRequest::platformVersion)).setter(RunTaskRequest.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()}).build();
    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propagateTags").getter(RunTaskRequest.getter(RunTaskRequest::propagateTagsAsString)).setter(RunTaskRequest.setter(Builder::propagateTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(RunTaskRequest.getter(RunTaskRequest::referenceId)).setter(RunTaskRequest.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(RunTaskRequest.getter(RunTaskRequest::startedBy)).setter(RunTaskRequest.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(RunTaskRequest.getter(RunTaskRequest::tags)).setter(RunTaskRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskDefinition").getter(RunTaskRequest.getter(RunTaskRequest::taskDefinition)).setter(RunTaskRequest.setter(Builder::taskDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(RunTaskRequest.getter(RunTaskRequest::clientToken)).setter(RunTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<TaskVolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumeConfigurations").getter(RunTaskRequest.getter(RunTaskRequest::volumeConfigurations)).setter(RunTaskRequest.setter(Builder::volumeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskVolumeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_STRATEGY_FIELD, CLUSTER_FIELD, COUNT_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD, GROUP_FIELD, LAUNCH_TYPE_FIELD, NETWORK_CONFIGURATION_FIELD, OVERRIDES_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, PLATFORM_VERSION_FIELD, PROPAGATE_TAGS_FIELD, REFERENCE_ID_FIELD, STARTED_BY_FIELD, TAGS_FIELD, TASK_DEFINITION_FIELD, CLIENT_TOKEN_FIELD, VOLUME_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("capacityProviderStrategy", CAPACITY_PROVIDER_STRATEGY_FIELD);
            this.put("cluster", CLUSTER_FIELD);
            this.put("count", COUNT_FIELD);
            this.put("enableECSManagedTags", ENABLE_ECS_MANAGED_TAGS_FIELD);
            this.put("enableExecuteCommand", ENABLE_EXECUTE_COMMAND_FIELD);
            this.put("group", GROUP_FIELD);
            this.put("launchType", LAUNCH_TYPE_FIELD);
            this.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("overrides", OVERRIDES_FIELD);
            this.put("placementConstraints", PLACEMENT_CONSTRAINTS_FIELD);
            this.put("placementStrategy", PLACEMENT_STRATEGY_FIELD);
            this.put("platformVersion", PLATFORM_VERSION_FIELD);
            this.put("propagateTags", PROPAGATE_TAGS_FIELD);
            this.put("referenceId", REFERENCE_ID_FIELD);
            this.put("startedBy", STARTED_BY_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("taskDefinition", TASK_DEFINITION_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("volumeConfigurations", VOLUME_CONFIGURATIONS_FIELD);
        }
    });
    private final List<CapacityProviderStrategyItem> capacityProviderStrategy;
    private final String cluster;
    private final Integer count;
    private final Boolean enableECSManagedTags;
    private final Boolean enableExecuteCommand;
    private final String group;
    private final String launchType;
    private final NetworkConfiguration networkConfiguration;
    private final TaskOverride overrides;
    private final List<PlacementConstraint> placementConstraints;
    private final List<PlacementStrategy> placementStrategy;
    private final String platformVersion;
    private final String propagateTags;
    private final String referenceId;
    private final String startedBy;
    private final List<Tag> tags;
    private final String taskDefinition;
    private final String clientToken;
    private final List<TaskVolumeConfiguration> volumeConfigurations;

    private RunTaskRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.cluster = builder.cluster;
        this.count = builder.count;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.group = builder.group;
        this.launchType = builder.launchType;
        this.networkConfiguration = builder.networkConfiguration;
        this.overrides = builder.overrides;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.platformVersion = builder.platformVersion;
        this.propagateTags = builder.propagateTags;
        this.referenceId = builder.referenceId;
        this.startedBy = builder.startedBy;
        this.tags = builder.tags;
        this.taskDefinition = builder.taskDefinition;
        this.clientToken = builder.clientToken;
        this.volumeConfigurations = builder.volumeConfigurations;
    }

    public final boolean hasCapacityProviderStrategy() {
        return this.capacityProviderStrategy != null && !(this.capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> capacityProviderStrategy() {
        return this.capacityProviderStrategy;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final Integer count() {
        return this.count;
    }

    public final Boolean enableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public final Boolean enableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public final String group() {
        return this.group;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final TaskOverride overrides() {
        return this.overrides;
    }

    public final boolean hasPlacementConstraints() {
        return this.placementConstraints != null && !(this.placementConstraints instanceof SdkAutoConstructList);
    }

    public final List<PlacementConstraint> placementConstraints() {
        return this.placementConstraints;
    }

    public final boolean hasPlacementStrategy() {
        return this.placementStrategy != null && !(this.placementStrategy instanceof SdkAutoConstructList);
    }

    public final List<PlacementStrategy> placementStrategy() {
        return this.placementStrategy;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final PropagateTags propagateTags() {
        return PropagateTags.fromValue(this.propagateTags);
    }

    public final String propagateTagsAsString() {
        return this.propagateTags;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String taskDefinition() {
        return this.taskDefinition;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasVolumeConfigurations() {
        return this.volumeConfigurations != null && !(this.volumeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TaskVolumeConfiguration> volumeConfigurations() {
        return this.volumeConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementConstraints() ? this.placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlacementStrategy() ? this.placementStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeConfigurations() ? this.volumeConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunTaskRequest)) {
            return false;
        }
        RunTaskRequest other = (RunTaskRequest)((Object)obj);
        return this.hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy() && Objects.equals(this.capacityProviderStrategy(), other.capacityProviderStrategy()) && Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.enableECSManagedTags(), other.enableECSManagedTags()) && Objects.equals(this.enableExecuteCommand(), other.enableExecuteCommand()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.overrides(), other.overrides()) && this.hasPlacementConstraints() == other.hasPlacementConstraints() && Objects.equals(this.placementConstraints(), other.placementConstraints()) && this.hasPlacementStrategy() == other.hasPlacementStrategy() && Objects.equals(this.placementStrategy(), other.placementStrategy()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.propagateTagsAsString(), other.propagateTagsAsString()) && Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.startedBy(), other.startedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.taskDefinition(), other.taskDefinition()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasVolumeConfigurations() == other.hasVolumeConfigurations() && Objects.equals(this.volumeConfigurations(), other.volumeConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"RunTaskRequest").add("CapacityProviderStrategy", this.hasCapacityProviderStrategy() ? this.capacityProviderStrategy() : null).add("Cluster", (Object)this.cluster()).add("Count", (Object)this.count()).add("EnableECSManagedTags", (Object)this.enableECSManagedTags()).add("EnableExecuteCommand", (Object)this.enableExecuteCommand()).add("Group", (Object)this.group()).add("LaunchType", (Object)this.launchTypeAsString()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Overrides", (Object)this.overrides()).add("PlacementConstraints", this.hasPlacementConstraints() ? this.placementConstraints() : null).add("PlacementStrategy", this.hasPlacementStrategy() ? this.placementStrategy() : null).add("PlatformVersion", (Object)this.platformVersion()).add("PropagateTags", (Object)this.propagateTagsAsString()).add("ReferenceId", (Object)this.referenceId()).add("StartedBy", (Object)this.startedBy()).add("Tags", this.hasTags() ? this.tags() : null).add("TaskDefinition", (Object)this.taskDefinition()).add("ClientToken", (Object)this.clientToken()).add("VolumeConfigurations", this.hasVolumeConfigurations() ? this.volumeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderStrategy()));
            }
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "enableECSManagedTags": {
                return Optional.ofNullable(clazz.cast(this.enableECSManagedTags()));
            }
            case "enableExecuteCommand": {
                return Optional.ofNullable(clazz.cast(this.enableExecuteCommand()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "launchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "placementConstraints": {
                return Optional.ofNullable(clazz.cast(this.placementConstraints()));
            }
            case "placementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategy()));
            }
            case "platformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "propagateTags": {
                return Optional.ofNullable(clazz.cast(this.propagateTagsAsString()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "taskDefinition": {
                return Optional.ofNullable(clazz.cast(this.taskDefinition()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "volumeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.volumeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RunTaskRequest, T> g) {
        return obj -> g.apply((RunTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private List<CapacityProviderStrategyItem> capacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String cluster;
        private Integer count;
        private Boolean enableECSManagedTags;
        private Boolean enableExecuteCommand;
        private String group;
        private String launchType;
        private NetworkConfiguration networkConfiguration;
        private TaskOverride overrides;
        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();
        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();
        private String platformVersion;
        private String propagateTags;
        private String referenceId;
        private String startedBy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String taskDefinition;
        private String clientToken;
        private List<TaskVolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunTaskRequest model) {
            super(model);
            this.capacityProviderStrategy(model.capacityProviderStrategy);
            this.cluster(model.cluster);
            this.count(model.count);
            this.enableECSManagedTags(model.enableECSManagedTags);
            this.enableExecuteCommand(model.enableExecuteCommand);
            this.group(model.group);
            this.launchType(model.launchType);
            this.networkConfiguration(model.networkConfiguration);
            this.overrides(model.overrides);
            this.placementConstraints(model.placementConstraints);
            this.placementStrategy(model.placementStrategy);
            this.platformVersion(model.platformVersion);
            this.propagateTags(model.propagateTags);
            this.referenceId(model.referenceId);
            this.startedBy(model.startedBy);
            this.tags(model.tags);
            this.taskDefinition(model.taskDefinition);
            this.clientToken(model.clientToken);
            this.volumeConfigurations(model.volumeConfigurations);
        }

        public final List<CapacityProviderStrategyItem.Builder> getCapacityProviderStrategy() {
            List<CapacityProviderStrategyItem.Builder> result = CapacityProviderStrategyCopier.copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> capacityProviderStrategy) {
            this.capacityProviderStrategy = CapacityProviderStrategyCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(CapacityProviderStrategyItem ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... capacityProviderStrategy) {
            this.capacityProviderStrategy(Stream.of(capacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCluster() {
            return this.cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Boolean getEnableECSManagedTags() {
            return this.enableECSManagedTags;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return this.enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final TaskOverride.Builder getOverrides() {
            return this.overrides != null ? this.overrides.toBuilder() : null;
        }

        public final void setOverrides(TaskOverride.BuilderImpl overrides) {
            this.overrides = overrides != null ? overrides.build() : null;
        }

        @Override
        public final Builder overrides(TaskOverride overrides) {
            this.overrides = overrides;
            return this;
        }

        public final List<PlacementConstraint.Builder> getPlacementConstraints() {
            List<PlacementConstraint.Builder> result = PlacementConstraintsCopier.copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint ... placementConstraints) {
            this.placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... placementConstraints) {
            this.placementConstraints(Stream.of(placementConstraints).map(c -> (PlacementConstraint)((PlacementConstraint.Builder)PlacementConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PlacementStrategy.Builder> getPlacementStrategy() {
            List<PlacementStrategy.Builder> result = PlacementStrategiesCopier.copyToBuilder(this.placementStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy ... placementStrategy) {
            this.placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... placementStrategy) {
            this.placementStrategy(Stream.of(placementStrategy).map(c -> (PlacementStrategy)((PlacementStrategy.Builder)PlacementStrategy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPropagateTags() {
            return this.propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskDefinition() {
            return this.taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<TaskVolumeConfiguration.Builder> getVolumeConfigurations() {
            List<TaskVolumeConfiguration.Builder> result = TaskVolumeConfigurationsCopier.copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<TaskVolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = TaskVolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<TaskVolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = TaskVolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(TaskVolumeConfiguration ... volumeConfigurations) {
            this.volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<TaskVolumeConfiguration.Builder> ... volumeConfigurations) {
            this.volumeConfigurations(Stream.of(volumeConfigurations).map(c -> (TaskVolumeConfiguration)((TaskVolumeConfiguration.Builder)TaskVolumeConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunTaskRequest build() {
            return new RunTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunTaskRequest> {
        public Builder capacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder capacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder capacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder cluster(String var1);

        public Builder count(Integer var1);

        public Builder enableECSManagedTags(Boolean var1);

        public Builder enableExecuteCommand(Boolean var1);

        public Builder group(String var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder overrides(TaskOverride var1);

        default public Builder overrides(Consumer<TaskOverride.Builder> overrides) {
            return this.overrides((TaskOverride)((TaskOverride.Builder)TaskOverride.builder().applyMutation(overrides)).build());
        }

        public Builder placementConstraints(Collection<PlacementConstraint> var1);

        public Builder placementConstraints(PlacementConstraint ... var1);

        public Builder placementConstraints(Consumer<PlacementConstraint.Builder> ... var1);

        public Builder placementStrategy(Collection<PlacementStrategy> var1);

        public Builder placementStrategy(PlacementStrategy ... var1);

        public Builder placementStrategy(Consumer<PlacementStrategy.Builder> ... var1);

        public Builder platformVersion(String var1);

        public Builder propagateTags(String var1);

        public Builder propagateTags(PropagateTags var1);

        public Builder referenceId(String var1);

        public Builder startedBy(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder taskDefinition(String var1);

        public Builder clientToken(String var1);

        public Builder volumeConfigurations(Collection<TaskVolumeConfiguration> var1);

        public Builder volumeConfigurations(TaskVolumeConfiguration ... var1);

        public Builder volumeConfigurations(Consumer<TaskVolumeConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

