/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerImage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerImage> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerName").getter(ContainerImage.getter(ContainerImage::containerName)).setter(ContainerImage.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ContainerImage.getter(ContainerImage::imageDigest)).setter(ContainerImage.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ContainerImage.getter(ContainerImage::image)).setter(ContainerImage.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, IMAGE_DIGEST_FIELD, IMAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("containerName", CONTAINER_NAME_FIELD);
            this.put("imageDigest", IMAGE_DIGEST_FIELD);
            this.put("image", IMAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final String imageDigest;
    private final String image;

    private ContainerImage(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.imageDigest = builder.imageDigest;
        this.image = builder.image;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final String image() {
        return this.image;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerImage)) {
            return false;
        }
        ContainerImage other = (ContainerImage)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.image(), other.image());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerImage").add("ContainerName", (Object)this.containerName()).add("ImageDigest", (Object)this.imageDigest()).add("Image", (Object)this.image()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerImage, T> g) {
        return obj -> g.apply((ContainerImage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private String imageDigest;
        private String image;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerImage model) {
            this.containerName(model.containerName);
            this.imageDigest(model.imageDigest);
            this.image(model.image);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public ContainerImage build() {
            return new ContainerImage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerImage> {
        public Builder containerName(String var1);

        public Builder imageDigest(String var1);

        public Builder image(String var1);
    }
}

