/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceDeploymentStatus {
    PENDING("PENDING"),
    SUCCESSFUL("SUCCESSFUL"),
    STOPPED("STOPPED"),
    STOP_REQUESTED("STOP_REQUESTED"),
    IN_PROGRESS("IN_PROGRESS"),
    ROLLBACK_IN_PROGRESS("ROLLBACK_IN_PROGRESS"),
    ROLLBACK_SUCCESSFUL("ROLLBACK_SUCCESSFUL"),
    ROLLBACK_FAILED("ROLLBACK_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceDeploymentStatus> VALUE_MAP;
    private final String value;

    private ServiceDeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceDeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceDeploymentStatus> knownValues() {
        EnumSet<ServiceDeploymentStatus> knownValues = EnumSet.allOf(ServiceDeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceDeploymentStatus.class, ServiceDeploymentStatus::toString);
    }
}

