/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceDeploymentsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeServiceDeploymentsRequest> {
    private static final SdkField<List<String>> SERVICE_DEPLOYMENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceDeploymentArns").getter(DescribeServiceDeploymentsRequest.getter(DescribeServiceDeploymentsRequest::serviceDeploymentArns)).setter(DescribeServiceDeploymentsRequest.setter(Builder::serviceDeploymentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDeploymentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_DEPLOYMENT_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceDeploymentsRequest.memberNameToFieldInitializer();
    private final List<String> serviceDeploymentArns;

    private DescribeServiceDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceDeploymentArns = builder.serviceDeploymentArns;
    }

    public final boolean hasServiceDeploymentArns() {
        return this.serviceDeploymentArns != null && !(this.serviceDeploymentArns instanceof SdkAutoConstructList);
    }

    public final List<String> serviceDeploymentArns() {
        return this.serviceDeploymentArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceDeploymentArns() ? this.serviceDeploymentArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceDeploymentsRequest)) {
            return false;
        }
        DescribeServiceDeploymentsRequest other = (DescribeServiceDeploymentsRequest)((Object)obj);
        return this.hasServiceDeploymentArns() == other.hasServiceDeploymentArns() && Objects.equals(this.serviceDeploymentArns(), other.serviceDeploymentArns());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceDeploymentsRequest").add("ServiceDeploymentArns", this.hasServiceDeploymentArns() ? this.serviceDeploymentArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceDeploymentArns": {
                return Optional.ofNullable(clazz.cast(this.serviceDeploymentArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("serviceDeploymentArns", SERVICE_DEPLOYMENT_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceDeploymentsRequest, T> g) {
        return obj -> g.apply((DescribeServiceDeploymentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private List<String> serviceDeploymentArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceDeploymentsRequest model) {
            super(model);
            this.serviceDeploymentArns(model.serviceDeploymentArns);
        }

        public final Collection<String> getServiceDeploymentArns() {
            if (this.serviceDeploymentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceDeploymentArns;
        }

        public final void setServiceDeploymentArns(Collection<String> serviceDeploymentArns) {
            this.serviceDeploymentArns = StringListCopier.copy(serviceDeploymentArns);
        }

        @Override
        public final Builder serviceDeploymentArns(Collection<String> serviceDeploymentArns) {
            this.serviceDeploymentArns = StringListCopier.copy(serviceDeploymentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceDeploymentArns(String ... serviceDeploymentArns) {
            this.serviceDeploymentArns(Arrays.asList(serviceDeploymentArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceDeploymentsRequest build() {
            return new DescribeServiceDeploymentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceDeploymentsRequest> {
        public Builder serviceDeploymentArns(Collection<String> var1);

        public Builder serviceDeploymentArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

