/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsClient;
import software.amazon.awssdk.services.ecs.model.Attribute;
import software.amazon.awssdk.services.ecs.model.ListAttributesRequest;
import software.amazon.awssdk.services.ecs.model.ListAttributesResponse;

public class ListAttributesIterable
implements SdkIterable<ListAttributesResponse> {
    private final EcsClient client;
    private final ListAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAttributesIterable(EcsClient client, ListAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttributesResponseFetcher();
    }

    public Iterator<ListAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Attribute> attributes() {
        Function<ListAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.attributes() != null) {
                return response.attributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAttributesResponseFetcher
    implements SyncPageFetcher<ListAttributesResponse> {
        private ListAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAttributesResponse nextPage(ListAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListAttributesIterable.this.client.listAttributes(ListAttributesIterable.this.firstRequest);
            }
            return ListAttributesIterable.this.client.listAttributes((ListAttributesRequest)((Object)ListAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

