/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyCopier;
import software.amazon.awssdk.services.ecs.model.CapacityProviderStrategyItem;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutClusterCapacityProvidersRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, PutClusterCapacityProvidersRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cluster").getter(PutClusterCapacityProvidersRequest.getter(PutClusterCapacityProvidersRequest::cluster)).setter(PutClusterCapacityProvidersRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviders").getter(PutClusterCapacityProvidersRequest.getter(PutClusterCapacityProvidersRequest::capacityProviders)).setter(PutClusterCapacityProvidersRequest.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CapacityProviderStrategyItem>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultCapacityProviderStrategy").getter(PutClusterCapacityProvidersRequest.getter(PutClusterCapacityProvidersRequest::defaultCapacityProviderStrategy)).setter(PutClusterCapacityProvidersRequest.setter(Builder::defaultCapacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultCapacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityProviderStrategyItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, CAPACITY_PROVIDERS_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD));
    private final String cluster;
    private final List<String> capacityProviders;
    private final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;

    private PutClusterCapacityProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.capacityProviders = builder.capacityProviders;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
    }

    public final String cluster() {
        return this.cluster;
    }

    public final boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public final List<String> capacityProviders() {
        return this.capacityProviders;
    }

    public final boolean hasDefaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy != null && !(this.defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutClusterCapacityProvidersRequest)) {
            return false;
        }
        PutClusterCapacityProvidersRequest other = (PutClusterCapacityProvidersRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && this.hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy() && Objects.equals(this.defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"PutClusterCapacityProvidersRequest").add("Cluster", (Object)this.cluster()).add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("DefaultCapacityProviderStrategy", this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "capacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "defaultCapacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.defaultCapacityProviderStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutClusterCapacityProvidersRequest, T> g) {
        return obj -> g.apply((PutClusterCapacityProvidersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<CapacityProviderStrategyItem> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutClusterCapacityProvidersRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.capacityProviders(model.capacityProviders);
            this.defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final Collection<String> getCapacityProviders() {
            if (this.capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityProviders;
        }

        @Override
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(String ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        public final Collection<CapacityProviderStrategyItem.Builder> getDefaultCapacityProviderStrategy() {
            if (this.defaultCapacityProviderStrategy instanceof SdkAutoConstructList) {
                return null;
            }
            return this.defaultCapacityProviderStrategy != null ? (Collection)this.defaultCapacityProviderStrategy.stream().map(CapacityProviderStrategyItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy).map(c -> (CapacityProviderStrategyItem)((CapacityProviderStrategyItem.Builder)CapacityProviderStrategyItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = CapacityProviderStrategyCopier.copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutClusterCapacityProvidersRequest build() {
            return new PutClusterCapacityProvidersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutClusterCapacityProvidersRequest> {
        public Builder cluster(String var1);

        public Builder capacityProviders(Collection<String> var1);

        public Builder capacityProviders(String ... var1);

        public Builder defaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> var1);

        public Builder defaultCapacityProviderStrategy(CapacityProviderStrategyItem ... var1);

        public Builder defaultCapacityProviderStrategy(Consumer<CapacityProviderStrategyItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

