/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountSettingDefaultResponse extends EcsResponse implements
        ToCopyableBuilder<PutAccountSettingDefaultResponse.Builder, PutAccountSettingDefaultResponse> {
    private static final SdkField<Setting> SETTING_FIELD = SdkField.<Setting> builder(MarshallingType.SDK_POJO)
            .memberName("setting").getter(getter(PutAccountSettingDefaultResponse::setting)).setter(setter(Builder::setting))
            .constructor(Setting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("setting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SETTING_FIELD));

    private final Setting setting;

    private PutAccountSettingDefaultResponse(BuilderImpl builder) {
        super(builder);
        this.setting = builder.setting;
    }

    /**
     * Returns the value of the Setting property for this object.
     * 
     * @return The value of the Setting property for this object.
     */
    public final Setting setting() {
        return setting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(setting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountSettingDefaultResponse)) {
            return false;
        }
        PutAccountSettingDefaultResponse other = (PutAccountSettingDefaultResponse) obj;
        return Objects.equals(setting(), other.setting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountSettingDefaultResponse").add("Setting", setting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "setting":
            return Optional.ofNullable(clazz.cast(setting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountSettingDefaultResponse, T> g) {
        return obj -> g.apply((PutAccountSettingDefaultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountSettingDefaultResponse> {
        /**
         * Sets the value of the Setting property for this object.
         *
         * @param setting
         *        The new value for the Setting property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setting(Setting setting);

        /**
         * Sets the value of the Setting property for this object.
         *
         * This is a convenience that creates an instance of the {@link Setting.Builder} avoiding the need to create one
         * manually via {@link Setting#builder()}.
         *
         * When the {@link Consumer} completes, {@link Setting.Builder#build()} is called immediately and its result is
         * passed to {@link #setting(Setting)}.
         * 
         * @param setting
         *        a consumer that will call methods on {@link Setting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #setting(Setting)
         */
        default Builder setting(Consumer<Setting.Builder> setting) {
            return setting(Setting.builder().applyMutation(setting).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private Setting setting;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountSettingDefaultResponse model) {
            super(model);
            setting(model.setting);
        }

        public final Setting.Builder getSetting() {
            return setting != null ? setting.toBuilder() : null;
        }

        @Override
        public final Builder setting(Setting setting) {
            this.setting = setting;
            return this;
        }

        public final void setSetting(Setting.BuilderImpl setting) {
            this.setting = setting != null ? setting.build() : null;
        }

        @Override
        public PutAccountSettingDefaultResponse build() {
            return new PutAccountSettingDefaultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
