/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTaskSetRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateTaskSetRequest.Builder, UpdateTaskSetRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTaskSetRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTaskSetRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> TASK_SET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTaskSetRequest::taskSet)).setter(setter(Builder::taskSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSet").build()).build();

    private static final SdkField<Scale> SCALE_FIELD = SdkField.<Scale> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateTaskSetRequest::scale)).setter(setter(Builder::scale)).constructor(Scale::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scale").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, SERVICE_FIELD,
            TASK_SET_FIELD, SCALE_FIELD));

    private final String cluster;

    private final String service;

    private final String taskSet;

    private final Scale scale;

    private UpdateTaskSetRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.service = builder.service;
        this.taskSet = builder.taskSet;
        this.scale = builder.scale;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set exists
     * in.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set
     *         exists in.
     */
    public String cluster() {
        return cluster;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.
     */
    public String service() {
        return service;
    }

    /**
     * <p>
     * The short name or full Amazon Resource Name (ARN) of the task set to update.
     * </p>
     * 
     * @return The short name or full Amazon Resource Name (ARN) of the task set to update.
     */
    public String taskSet() {
        return taskSet;
    }

    /**
     * Returns the value of the Scale property for this object.
     * 
     * @return The value of the Scale property for this object.
     */
    public Scale scale() {
        return scale;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(taskSet());
        hashCode = 31 * hashCode + Objects.hashCode(scale());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTaskSetRequest)) {
            return false;
        }
        UpdateTaskSetRequest other = (UpdateTaskSetRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(service(), other.service())
                && Objects.equals(taskSet(), other.taskSet()) && Objects.equals(scale(), other.scale());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTaskSetRequest").add("Cluster", cluster()).add("Service", service())
                .add("TaskSet", taskSet()).add("Scale", scale()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "taskSet":
            return Optional.ofNullable(clazz.cast(taskSet()));
        case "scale":
            return Optional.ofNullable(clazz.cast(scale()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTaskSetRequest, T> g) {
        return obj -> g.apply((UpdateTaskSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTaskSetRequest> {
        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task set
         * exists in.
         * </p>
         * 
         * @param cluster
         *        The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the task
         *        set exists in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.
         * </p>
         * 
         * @param service
         *        The short name or full Amazon Resource Name (ARN) of the service that the task set exists in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The short name or full Amazon Resource Name (ARN) of the task set to update.
         * </p>
         * 
         * @param taskSet
         *        The short name or full Amazon Resource Name (ARN) of the task set to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSet(String taskSet);

        /**
         * Sets the value of the Scale property for this object.
         *
         * @param scale
         *        The new value for the Scale property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scale(Scale scale);

        /**
         * Sets the value of the Scale property for this object.
         *
         * This is a convenience that creates an instance of the {@link Scale.Builder} avoiding the need to create one
         * manually via {@link Scale#builder()}.
         *
         * When the {@link Consumer} completes, {@link Scale.Builder#build()} is called immediately and its result is
         * passed to {@link #scale(Scale)}.
         * 
         * @param scale
         *        a consumer that will call methods on {@link Scale.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scale(Scale)
         */
        default Builder scale(Consumer<Scale.Builder> scale) {
            return scale(Scale.builder().applyMutation(scale).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private String service;

        private String taskSet;

        private Scale scale;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTaskSetRequest model) {
            super(model);
            cluster(model.cluster);
            service(model.service);
            taskSet(model.taskSet);
            scale(model.scale);
        }

        public final String getCluster() {
            return cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getTaskSet() {
            return taskSet;
        }

        @Override
        public final Builder taskSet(String taskSet) {
            this.taskSet = taskSet;
            return this;
        }

        public final void setTaskSet(String taskSet) {
            this.taskSet = taskSet;
        }

        public final Scale.Builder getScale() {
            return scale != null ? scale.toBuilder() : null;
        }

        @Override
        public final Builder scale(Scale scale) {
            this.scale = scale;
            return this;
        }

        public final void setScale(Scale.BuilderImpl scale) {
            this.scale = scale != null ? scale.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTaskSetRequest build() {
            return new UpdateTaskSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
