/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTaskDefinitionFamiliesResponse extends EcsResponse implements
        ToCopyableBuilder<ListTaskDefinitionFamiliesResponse.Builder, ListTaskDefinitionFamiliesResponse> {
    private static final SdkField<List<String>> FAMILIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListTaskDefinitionFamiliesResponse::families))
            .setter(setter(Builder::families))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("families").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTaskDefinitionFamiliesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> families;

    private final String nextToken;

    private ListTaskDefinitionFamiliesResponse(BuilderImpl builder) {
        super(builder);
        this.families = builder.families;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Families property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFamilies() {
        return families != null && !(families instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFamilies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.
     */
    public List<String> families() {
        return families;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When the
     * results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value can be
     * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request.
     *         When the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>,
     *         this value can be used to retrieve the next page of results. This value is <code>null</code> when there
     *         are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(families());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskDefinitionFamiliesResponse)) {
            return false;
        }
        ListTaskDefinitionFamiliesResponse other = (ListTaskDefinitionFamiliesResponse) obj;
        return Objects.equals(families(), other.families()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTaskDefinitionFamiliesResponse").add("Families", families()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "families":
            return Optional.ofNullable(clazz.cast(families()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskDefinitionFamiliesResponse, T> g) {
        return obj -> g.apply((ListTaskDefinitionFamiliesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTaskDefinitionFamiliesResponse> {
        /**
         * <p>
         * The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.
         * </p>
         * 
         * @param families
         *        The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder families(Collection<String> families);

        /**
         * <p>
         * The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code> request.
         * </p>
         * 
         * @param families
         *        The list of task definition family names that match the <code>ListTaskDefinitionFamilies</code>
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder families(String... families);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code> request. When
         * the results of a <code>ListTaskDefinitionFamilies</code> request exceed <code>maxResults</code>, this value
         * can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListTaskDefinitionFamilies</code>
         *        request. When the results of a <code>ListTaskDefinitionFamilies</code> request exceed
         *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private List<String> families = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskDefinitionFamiliesResponse model) {
            super(model);
            families(model.families);
            nextToken(model.nextToken);
        }

        public final Collection<String> getFamilies() {
            return families;
        }

        @Override
        public final Builder families(Collection<String> families) {
            this.families = StringListCopier.copy(families);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder families(String... families) {
            families(Arrays.asList(families));
            return this;
        }

        public final void setFamilies(Collection<String> families) {
            this.families = StringListCopier.copy(families);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTaskDefinitionFamiliesResponse build() {
            return new ListTaskDefinitionFamiliesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
