/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with identifying information for an Amazon ECR image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageIdentifier implements SdkPojo, Serializable, ToCopyableBuilder<ImageIdentifier.Builder, ImageIdentifier> {
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageDigest").getter(getter(ImageIdentifier::imageDigest)).setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()).build();

    private static final SdkField<String> IMAGE_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageTag").getter(getter(ImageIdentifier::imageTag)).setter(setter(Builder::imageTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTag").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DIGEST_FIELD,
            IMAGE_TAG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String imageDigest;

    private final String imageTag;

    private ImageIdentifier(BuilderImpl builder) {
        this.imageDigest = builder.imageDigest;
        this.imageTag = builder.imageTag;
    }

    /**
     * <p>
     * The <code>sha256</code> digest of the image manifest.
     * </p>
     * 
     * @return The <code>sha256</code> digest of the image manifest.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    /**
     * <p>
     * The tag that's used for the image.
     * </p>
     * 
     * @return The tag that's used for the image.
     */
    public final String imageTag() {
        return imageTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(imageTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageIdentifier)) {
            return false;
        }
        ImageIdentifier other = (ImageIdentifier) obj;
        return Objects.equals(imageDigest(), other.imageDigest()) && Objects.equals(imageTag(), other.imageTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageIdentifier").add("ImageDigest", imageDigest()).add("ImageTag", imageTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "imageTag":
            return Optional.ofNullable(clazz.cast(imageTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageIdentifier, T> g) {
        return obj -> g.apply((ImageIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageIdentifier> {
        /**
         * <p>
         * The <code>sha256</code> digest of the image manifest.
         * </p>
         * 
         * @param imageDigest
         *        The <code>sha256</code> digest of the image manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * The tag that's used for the image.
         * </p>
         * 
         * @param imageTag
         *        The tag that's used for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTag(String imageTag);
    }

    static final class BuilderImpl implements Builder {
        private String imageDigest;

        private String imageTag;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageIdentifier model) {
            imageDigest(model.imageDigest);
            imageTag(model.imageTag);
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final String getImageTag() {
            return imageTag;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        @Override
        public ImageIdentifier build() {
            return new ImageIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
