/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ecrpublic.EcrPublicAsyncClient;
import software.amazon.awssdk.services.ecrpublic.EcrPublicServiceClientConfiguration;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchCheckLayerAvailabilityResponse;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.BatchDeleteImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.CompleteLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.ecrpublic.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicException;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicRequest;
import software.amazon.awssdk.services.ecrpublic.model.EmptyUploadException;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.GetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.ImageDigestDoesNotMatchException;
import software.amazon.awssdk.services.ecrpublic.model.ImageNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadRequest;
import software.amazon.awssdk.services.ecrpublic.model.InitiateLayerUploadResponse;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidLayerPartException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidParameterException;
import software.amazon.awssdk.services.ecrpublic.model.InvalidTagParameterException;
import software.amazon.awssdk.services.ecrpublic.model.LayerAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.LayerPartTooSmallException;
import software.amazon.awssdk.services.ecrpublic.model.LayersNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.LimitExceededException;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutImageRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutImageResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRegistryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataRequest;
import software.amazon.awssdk.services.ecrpublic.model.PutRepositoryCatalogDataResponse;
import software.amazon.awssdk.services.ecrpublic.model.ReferencedImagesNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RegistryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryAlreadyExistsException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryCatalogDataNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotEmptyException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.RepositoryPolicyNotFoundException;
import software.amazon.awssdk.services.ecrpublic.model.ServerException;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyRequest;
import software.amazon.awssdk.services.ecrpublic.model.SetRepositoryPolicyResponse;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.TagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.TooManyTagsException;
import software.amazon.awssdk.services.ecrpublic.model.UnsupportedCommandException;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceRequest;
import software.amazon.awssdk.services.ecrpublic.model.UntagResourceResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartRequest;
import software.amazon.awssdk.services.ecrpublic.model.UploadLayerPartResponse;
import software.amazon.awssdk.services.ecrpublic.model.UploadNotFoundException;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeImageTagsPublisher;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeImagesPublisher;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeRegistriesPublisher;
import software.amazon.awssdk.services.ecrpublic.paginators.DescribeRepositoriesPublisher;
import software.amazon.awssdk.services.ecrpublic.transform.BatchCheckLayerAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.BatchDeleteImageRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.CompleteLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DeleteRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeImageTagsRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeImagesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeRegistriesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.DescribeRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetAuthorizationTokenRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRegistryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRepositoryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.GetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.InitiateLayerUploadRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutImageRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutRegistryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.PutRepositoryCatalogDataRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.SetRepositoryPolicyRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ecrpublic.transform.UploadLayerPartRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultEcrPublicAsyncClient
implements EcrPublicAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultEcrPublicAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final EcrPublicServiceClientConfiguration serviceClientConfiguration;

    protected DefaultEcrPublicAsyncClient(EcrPublicServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<BatchCheckLayerAvailabilityResponse> batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchCheckLayerAvailabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchCheckLayerAvailability");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchCheckLayerAvailabilityResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchCheckLayerAvailability").withMarshaller((Marshaller)new BatchCheckLayerAvailabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchCheckLayerAvailabilityRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$batchCheckLayerAvailability$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$batchCheckLayerAvailability$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchDeleteImageResponse> batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteImageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteImage").withMarshaller((Marshaller)new BatchDeleteImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchDeleteImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$batchDeleteImage$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$batchDeleteImage$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CompleteLayerUploadResponse> completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, completeLayerUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteLayerUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteLayerUploadResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteLayerUpload").withMarshaller((Marshaller)new CompleteLayerUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)completeLayerUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$completeLayerUpload$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$completeLayerUpload$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRepositoryResponse> createRepository(CreateRepositoryRequest createRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, createRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$createRepository$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$createRepository$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRepositoryResponse> deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRepositoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepository");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRepositoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$deleteRepository$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$deleteRepository$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRepositoryPolicyResponse> deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRepositoryPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepositoryPolicy").withMarshaller((Marshaller)new DeleteRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRepositoryPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$deleteRepositoryPolicy$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$deleteRepositoryPolicy$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImageTagsResponse> describeImageTags(DescribeImageTagsRequest describeImageTagsRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeImageTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImageTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImageTagsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImageTags").withMarshaller((Marshaller)new DescribeImageTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImageTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeImageTags$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeImageTags$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeImageTagsPublisher describeImageTagsPaginator(DescribeImageTagsRequest describeImageTagsRequest) {
        return new DescribeImageTagsPublisher(this, this.applyPaginatorUserAgent(describeImageTagsRequest));
    }

    @Override
    public CompletableFuture<DescribeImagesResponse> describeImages(DescribeImagesRequest describeImagesRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImagesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImages").withMarshaller((Marshaller)new DescribeImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeImages$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeImages$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeImagesPublisher describeImagesPaginator(DescribeImagesRequest describeImagesRequest) {
        return new DescribeImagesPublisher(this, this.applyPaginatorUserAgent(describeImagesRequest));
    }

    @Override
    public CompletableFuture<DescribeRegistriesResponse> describeRegistries(DescribeRegistriesRequest describeRegistriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeRegistriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRegistries");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRegistriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRegistries").withMarshaller((Marshaller)new DescribeRegistriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRegistriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeRegistries$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeRegistries$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeRegistriesPublisher describeRegistriesPaginator(DescribeRegistriesRequest describeRegistriesRequest) {
        return new DescribeRegistriesPublisher(this, this.applyPaginatorUserAgent(describeRegistriesRequest));
    }

    @Override
    public CompletableFuture<DescribeRepositoriesResponse> describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeRepositoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRepositories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRepositoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRepositories").withMarshaller((Marshaller)new DescribeRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRepositoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$describeRepositories$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$describeRepositories$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeRepositoriesPublisher describeRepositoriesPaginator(DescribeRepositoriesRequest describeRepositoriesRequest) {
        return new DescribeRepositoriesPublisher(this, this.applyPaginatorUserAgent(describeRepositoriesRequest));
    }

    @Override
    public CompletableFuture<GetAuthorizationTokenResponse> getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAuthorizationTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAuthorizationToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAuthorizationTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAuthorizationToken").withMarshaller((Marshaller)new GetAuthorizationTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAuthorizationTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getAuthorizationToken$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getAuthorizationToken$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRegistryCatalogDataResponse> getRegistryCatalogData(GetRegistryCatalogDataRequest getRegistryCatalogDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRegistryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRegistryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRegistryCatalogDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRegistryCatalogData").withMarshaller((Marshaller)new GetRegistryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRegistryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getRegistryCatalogData$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getRegistryCatalogData$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryCatalogDataResponse> getRepositoryCatalogData(GetRepositoryCatalogDataRequest getRepositoryCatalogDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRepositoryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryCatalogDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryCatalogData").withMarshaller((Marshaller)new GetRepositoryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getRepositoryCatalogData$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getRepositoryCatalogData$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRepositoryPolicyResponse> getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, getRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRepositoryPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryPolicy").withMarshaller((Marshaller)new GetRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRepositoryPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$getRepositoryPolicy$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$getRepositoryPolicy$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitiateLayerUploadResponse> initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, initiateLayerUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitiateLayerUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateLayerUploadResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateLayerUpload").withMarshaller((Marshaller)new InitiateLayerUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)initiateLayerUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$initiateLayerUpload$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$initiateLayerUpload$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$listTagsForResource$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$listTagsForResource$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutImageResponse> putImage(PutImageRequest putImageRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, putImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutImage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutImageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutImage").withMarshaller((Marshaller)new PutImageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putImageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$putImage$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$putImage$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRegistryCatalogDataResponse> putRegistryCatalogData(PutRegistryCatalogDataRequest putRegistryCatalogDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRegistryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRegistryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRegistryCatalogDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRegistryCatalogData").withMarshaller((Marshaller)new PutRegistryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRegistryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$putRegistryCatalogData$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$putRegistryCatalogData$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutRepositoryCatalogDataResponse> putRepositoryCatalogData(PutRepositoryCatalogDataRequest putRepositoryCatalogDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, putRepositoryCatalogDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRepositoryCatalogData");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRepositoryCatalogDataResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRepositoryCatalogData").withMarshaller((Marshaller)new PutRepositoryCatalogDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putRepositoryCatalogDataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$putRepositoryCatalogData$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$putRepositoryCatalogData$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetRepositoryPolicyResponse> setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, setRepositoryPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetRepositoryPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetRepositoryPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetRepositoryPolicy").withMarshaller((Marshaller)new SetRepositoryPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setRepositoryPolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$setRepositoryPolicy$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$setRepositoryPolicy$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$tagResource$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$tagResource$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$untagResource$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$untagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UploadLayerPartResponse> uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        List<MetricPublisher> metricPublishers = DefaultEcrPublicAsyncClient.resolveMetricPublishers(this.clientConfiguration, uploadLayerPartRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"ECR PUBLIC");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UploadLayerPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadLayerPartResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadLayerPart").withMarshaller((Marshaller)new UploadLayerPartRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)uploadLayerPartRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultEcrPublicAsyncClient.lambda$uploadLayerPart$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultEcrPublicAsyncClient.lambda$uploadLayerPart$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final EcrPublicServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "ecr-public";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EcrPublicException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedCommandException").exceptionBuilderSupplier(UnsupportedCommandException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LayerPartTooSmallException").exceptionBuilderSupplier(LayerPartTooSmallException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLayerPartException").exceptionBuilderSupplier(InvalidLayerPartException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImageTagAlreadyExistsException").exceptionBuilderSupplier(ImageTagAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServerException").exceptionBuilderSupplier(ServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNotEmptyException").exceptionBuilderSupplier(RepositoryNotEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LayerAlreadyExistsException").exceptionBuilderSupplier(LayerAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImageDigestDoesNotMatchException").exceptionBuilderSupplier(ImageDigestDoesNotMatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RegistryNotFoundException").exceptionBuilderSupplier(RegistryNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EmptyUploadException").exceptionBuilderSupplier(EmptyUploadException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").exceptionBuilderSupplier(InvalidTagParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImageNotFoundException").exceptionBuilderSupplier(ImageNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryCatalogDataNotFoundException").exceptionBuilderSupplier(RepositoryCatalogDataNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LayersNotFoundException").exceptionBuilderSupplier(LayersNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReferencedImagesNotFoundException").exceptionBuilderSupplier(ReferencedImagesNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLayerException").exceptionBuilderSupplier(InvalidLayerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryNotFoundException").exceptionBuilderSupplier(RepositoryNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryAlreadyExistsException").exceptionBuilderSupplier(RepositoryAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RepositoryPolicyNotFoundException").exceptionBuilderSupplier(RepositoryPolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImageAlreadyExistsException").exceptionBuilderSupplier(ImageAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UploadNotFoundException").exceptionBuilderSupplier(UploadNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends EcrPublicRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.96").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EcrPublicRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$uploadLayerPart$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$uploadLayerPart$67(List metricPublishers, MetricCollector apiCallMetricCollector, UploadLayerPartResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$64(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$61(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setRepositoryPolicy$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setRepositoryPolicy$58(List metricPublishers, MetricCollector apiCallMetricCollector, SetRepositoryPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putRepositoryCatalogData$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRepositoryCatalogData$55(List metricPublishers, MetricCollector apiCallMetricCollector, PutRepositoryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putRegistryCatalogData$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putRegistryCatalogData$52(List metricPublishers, MetricCollector apiCallMetricCollector, PutRegistryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putImage$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putImage$49(List metricPublishers, MetricCollector apiCallMetricCollector, PutImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$46(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$initiateLayerUpload$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initiateLayerUpload$43(List metricPublishers, MetricCollector apiCallMetricCollector, InitiateLayerUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositoryPolicy$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryPolicy$40(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRepositoryCatalogData$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRepositoryCatalogData$37(List metricPublishers, MetricCollector apiCallMetricCollector, GetRepositoryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRegistryCatalogData$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRegistryCatalogData$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetRegistryCatalogDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAuthorizationToken$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAuthorizationToken$31(List metricPublishers, MetricCollector apiCallMetricCollector, GetAuthorizationTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRepositories$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRepositories$28(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRepositoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRegistries$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRegistries$25(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRegistriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeImages$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImages$22(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeImageTags$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImageTags$19(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImageTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRepositoryPolicy$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepositoryPolicy$16(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRepositoryPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRepository$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRepository$13(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRepository$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRepository$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRepositoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$completeLayerUpload$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$completeLayerUpload$7(List metricPublishers, MetricCollector apiCallMetricCollector, CompleteLayerUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchDeleteImage$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteImage$4(List metricPublishers, MetricCollector apiCallMetricCollector, BatchDeleteImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchCheckLayerAvailability$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchCheckLayerAvailability$1(List metricPublishers, MetricCollector apiCallMetricCollector, BatchCheckLayerAvailabilityResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

