/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferencedImageDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferencedImageDetail> {
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ReferencedImageDetail.getter(ReferencedImageDetail::imageDigest)).setter(ReferencedImageDetail.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<Long> IMAGE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("imageSizeInBytes").getter(ReferencedImageDetail.getter(ReferencedImageDetail::imageSizeInBytes)).setter(ReferencedImageDetail.setter(Builder::imageSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSizeInBytes").build()}).build();
    private static final SdkField<Instant> IMAGE_PUSHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("imagePushedAt").getter(ReferencedImageDetail.getter(ReferencedImageDetail::imagePushedAt)).setter(ReferencedImageDetail.setter(Builder::imagePushedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePushedAt").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageManifestMediaType").getter(ReferencedImageDetail.getter(ReferencedImageDetail::imageManifestMediaType)).setter(ReferencedImageDetail.setter(Builder::imageManifestMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build()}).build();
    private static final SdkField<String> ARTIFACT_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactMediaType").getter(ReferencedImageDetail.getter(ReferencedImageDetail::artifactMediaType)).setter(ReferencedImageDetail.setter(Builder::artifactMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactMediaType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_DIGEST_FIELD, IMAGE_SIZE_IN_BYTES_FIELD, IMAGE_PUSHED_AT_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD, ARTIFACT_MEDIA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String imageDigest;
    private final Long imageSizeInBytes;
    private final Instant imagePushedAt;
    private final String imageManifestMediaType;
    private final String artifactMediaType;

    private ReferencedImageDetail(BuilderImpl builder) {
        this.imageDigest = builder.imageDigest;
        this.imageSizeInBytes = builder.imageSizeInBytes;
        this.imagePushedAt = builder.imagePushedAt;
        this.imageManifestMediaType = builder.imageManifestMediaType;
        this.artifactMediaType = builder.artifactMediaType;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final Long imageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    public final Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public final String imageManifestMediaType() {
        return this.imageManifestMediaType;
    }

    public final String artifactMediaType() {
        return this.artifactMediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifestMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactMediaType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferencedImageDetail)) {
            return false;
        }
        ReferencedImageDetail other = (ReferencedImageDetail)obj;
        return Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.imageSizeInBytes(), other.imageSizeInBytes()) && Objects.equals(this.imagePushedAt(), other.imagePushedAt()) && Objects.equals(this.imageManifestMediaType(), other.imageManifestMediaType()) && Objects.equals(this.artifactMediaType(), other.artifactMediaType());
    }

    public final String toString() {
        return ToString.builder((String)"ReferencedImageDetail").add("ImageDigest", (Object)this.imageDigest()).add("ImageSizeInBytes", (Object)this.imageSizeInBytes()).add("ImagePushedAt", (Object)this.imagePushedAt()).add("ImageManifestMediaType", (Object)this.imageManifestMediaType()).add("ArtifactMediaType", (Object)this.artifactMediaType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "imageSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.imageSizeInBytes()));
            }
            case "imagePushedAt": {
                return Optional.ofNullable(clazz.cast(this.imagePushedAt()));
            }
            case "imageManifestMediaType": {
                return Optional.ofNullable(clazz.cast(this.imageManifestMediaType()));
            }
            case "artifactMediaType": {
                return Optional.ofNullable(clazz.cast(this.artifactMediaType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferencedImageDetail, T> g) {
        return obj -> g.apply((ReferencedImageDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageDigest;
        private Long imageSizeInBytes;
        private Instant imagePushedAt;
        private String imageManifestMediaType;
        private String artifactMediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferencedImageDetail model) {
            this.imageDigest(model.imageDigest);
            this.imageSizeInBytes(model.imageSizeInBytes);
            this.imagePushedAt(model.imagePushedAt);
            this.imageManifestMediaType(model.imageManifestMediaType);
            this.artifactMediaType(model.artifactMediaType);
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final Long getImageSizeInBytes() {
            return this.imageSizeInBytes;
        }

        @Override
        public final Builder imageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
            return this;
        }

        public final void setImageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        public final String getImageManifestMediaType() {
            return this.imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        public final String getArtifactMediaType() {
            return this.artifactMediaType;
        }

        @Override
        public final Builder artifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
            return this;
        }

        public final void setArtifactMediaType(String artifactMediaType) {
            this.artifactMediaType = artifactMediaType;
        }

        public ReferencedImageDetail build() {
            return new ReferencedImageDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferencedImageDetail> {
        public Builder imageDigest(String var1);

        public Builder imageSizeInBytes(Long var1);

        public Builder imagePushedAt(Instant var1);

        public Builder imageManifestMediaType(String var1);

        public Builder artifactMediaType(String var1);
    }
}

