/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.Image;
import software.amazon.awssdk.services.ecr.model.ImageFailure;
import software.amazon.awssdk.services.ecr.model.ImageFailureListCopier;
import software.amazon.awssdk.services.ecr.model.ImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetImageResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, BatchGetImageResponse> {
    private static final SdkField<List<Image>> IMAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetImageResponse.getter(BatchGetImageResponse::images)).setter(BatchGetImageResponse.setter(Builder::images)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ImageFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchGetImageResponse.getter(BatchGetImageResponse::failures)).setter(BatchGetImageResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGES_FIELD, FAILURES_FIELD));
    private final List<Image> images;
    private final List<ImageFailure> failures;

    private BatchGetImageResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.failures = builder.failures;
    }

    public List<Image> images() {
        return this.images;
    }

    public List<ImageFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.images());
        hashCode = 31 * hashCode + Objects.hashCode(this.failures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageResponse)) {
            return false;
        }
        BatchGetImageResponse other = (BatchGetImageResponse)((Object)obj);
        return Objects.equals(this.images(), other.images()) && Objects.equals(this.failures(), other.failures());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetImageResponse").add("Images", this.images()).add("Failures", this.failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "images": {
                return Optional.ofNullable(clazz.cast(this.images()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetImageResponse, T> g) {
        return obj -> g.apply((BatchGetImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();
        private List<ImageFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetImageResponse model) {
            super(model);
            this.images(model.images);
            this.failures(model.failures);
        }

        public final Collection<Image.Builder> getImages() {
            return this.images != null ? (Collection)this.images.stream().map(Image::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image ... images) {
            this.images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder> ... images) {
            this.images(Stream.of(images).map(c -> (Image)((Image.Builder)Image.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        public final Collection<ImageFailure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(ImageFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<ImageFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (ImageFailure)((ImageFailure.Builder)ImageFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<ImageFailure.BuilderImpl> failures) {
            this.failures = ImageFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public BatchGetImageResponse build() {
            return new BatchGetImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetImageResponse> {
        public Builder images(Collection<Image> var1);

        public Builder images(Image ... var1);

        public Builder images(Consumer<Image.Builder> ... var1);

        public Builder failures(Collection<ImageFailure> var1);

        public Builder failures(ImageFailure ... var1);

        public Builder failures(Consumer<ImageFailure.Builder> ... var1);
    }
}

