/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.GetAuthorizationTokenRegistryIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAuthorizationTokenRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, GetAuthorizationTokenRequest> {
    private static final SdkField<List<String>> REGISTRY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAuthorizationTokenRequest.getter(GetAuthorizationTokenRequest::registryIds)).setter(GetAuthorizationTokenRequest.setter(Builder::registryIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_IDS_FIELD));
    private final List<String> registryIds;

    private GetAuthorizationTokenRequest(BuilderImpl builder) {
        super(builder);
        this.registryIds = builder.registryIds;
    }

    public List<String> registryIds() {
        return this.registryIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenRequest)) {
            return false;
        }
        GetAuthorizationTokenRequest other = (GetAuthorizationTokenRequest)((Object)obj);
        return Objects.equals(this.registryIds(), other.registryIds());
    }

    public String toString() {
        return ToString.builder((String)"GetAuthorizationTokenRequest").add("RegistryIds", this.registryIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryIds": {
                return Optional.ofNullable(clazz.cast(this.registryIds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenRequest, T> g) {
        return obj -> g.apply((GetAuthorizationTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private List<String> registryIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenRequest model) {
            super(model);
            this.registryIds(model.registryIds);
        }

        public final Collection<String> getRegistryIds() {
            return this.registryIds;
        }

        @Override
        public final Builder registryIds(Collection<String> registryIds) {
            this.registryIds = GetAuthorizationTokenRegistryIdListCopier.copy(registryIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registryIds(String ... registryIds) {
            this.registryIds(Arrays.asList(registryIds));
            return this;
        }

        public final void setRegistryIds(Collection<String> registryIds) {
            this.registryIds = GetAuthorizationTokenRegistryIdListCopier.copy(registryIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAuthorizationTokenRequest build() {
            return new GetAuthorizationTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAuthorizationTokenRequest> {
        public Builder registryIds(Collection<String> var1);

        public Builder registryIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

