/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecr.endpoints.EcrEndpointParams;
import software.amazon.awssdk.services.ecr.endpoints.EcrEndpointProvider;
import software.amazon.awssdk.services.ecr.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.ecr.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.ecr.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultEcrEndpointProvider
implements EcrEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(EcrEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultEcrEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(EcrEndpointParams params, String region) {
        RuleResult result = DefaultEcrEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        return DefaultEcrEndpointProvider.endpointRule6(params, region);
    }

    private static RuleResult endpointRule1(EcrEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            return DefaultEcrEndpointProvider.endpointRule3(params);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(EcrEndpointParams params) {
        if (params.useDualStack().booleanValue()) {
            return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
        }
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
    }

    private static RuleResult endpointRule6(EcrEndpointParams params, String region) {
        RuleResult result = DefaultEcrEndpointProvider.endpointRule7(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule7(EcrEndpointParams params, String region) {
        if (region != null) {
            return DefaultEcrEndpointProvider.endpointRule8(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(EcrEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-us-gov".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-cn".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso-b".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso-e".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso-e".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso-e".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso-e".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso-f".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso-f".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-iso-f".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-iso-f".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && !params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if ("aws-eusc".equals(partitionResult.name()) && params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
            }
            RuleResult result = DefaultEcrEndpointProvider.endpointRule41(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEcrEndpointProvider.endpointRule45(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultEcrEndpointProvider.endpointRule49(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule41(EcrEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEcrEndpointProvider.endpointRule42(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(EcrEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule45(EcrEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && !params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEcrEndpointProvider.endpointRule46(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule46(EcrEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule49(EcrEndpointParams params, RulePartition partitionResult, String region) {
        if (!params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultEcrEndpointProvider.endpointRule50(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule50(EcrEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://api.ecr." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

