/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyTargetStorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitioningImageTotalCount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitioningImageTotalCount> {
    private static final SdkField<String> TARGET_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetStorageClass").getter(TransitioningImageTotalCount.getter(TransitioningImageTotalCount::targetStorageClassAsString)).setter(TransitioningImageTotalCount.setter(Builder::targetStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStorageClass").build()}).build();
    private static final SdkField<Integer> IMAGE_TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("imageTotalCount").getter(TransitioningImageTotalCount.getter(TransitioningImageTotalCount::imageTotalCount)).setter(TransitioningImageTotalCount.setter(Builder::imageTotalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_STORAGE_CLASS_FIELD, IMAGE_TOTAL_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitioningImageTotalCount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetStorageClass;
    private final Integer imageTotalCount;

    private TransitioningImageTotalCount(BuilderImpl builder) {
        this.targetStorageClass = builder.targetStorageClass;
        this.imageTotalCount = builder.imageTotalCount;
    }

    public final LifecyclePolicyTargetStorageClass targetStorageClass() {
        return LifecyclePolicyTargetStorageClass.fromValue(this.targetStorageClass);
    }

    public final String targetStorageClassAsString() {
        return this.targetStorageClass;
    }

    public final Integer imageTotalCount() {
        return this.imageTotalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTotalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitioningImageTotalCount)) {
            return false;
        }
        TransitioningImageTotalCount other = (TransitioningImageTotalCount)obj;
        return Objects.equals(this.targetStorageClassAsString(), other.targetStorageClassAsString()) && Objects.equals(this.imageTotalCount(), other.imageTotalCount());
    }

    public final String toString() {
        return ToString.builder((String)"TransitioningImageTotalCount").add("TargetStorageClass", (Object)this.targetStorageClassAsString()).add("ImageTotalCount", (Object)this.imageTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetStorageClass": {
                return Optional.ofNullable(clazz.cast(this.targetStorageClassAsString()));
            }
            case "imageTotalCount": {
                return Optional.ofNullable(clazz.cast(this.imageTotalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetStorageClass", TARGET_STORAGE_CLASS_FIELD);
        map.put("imageTotalCount", IMAGE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitioningImageTotalCount, T> g) {
        return obj -> g.apply((TransitioningImageTotalCount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetStorageClass;
        private Integer imageTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitioningImageTotalCount model) {
            this.targetStorageClass(model.targetStorageClass);
            this.imageTotalCount(model.imageTotalCount);
        }

        public final String getTargetStorageClass() {
            return this.targetStorageClass;
        }

        public final void setTargetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
        }

        @Override
        public final Builder targetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
            return this;
        }

        @Override
        public final Builder targetStorageClass(LifecyclePolicyTargetStorageClass targetStorageClass) {
            this.targetStorageClass(targetStorageClass == null ? null : targetStorageClass.toString());
            return this;
        }

        public final Integer getImageTotalCount() {
            return this.imageTotalCount;
        }

        public final void setImageTotalCount(Integer imageTotalCount) {
            this.imageTotalCount = imageTotalCount;
        }

        @Override
        public final Builder imageTotalCount(Integer imageTotalCount) {
            this.imageTotalCount = imageTotalCount;
            return this;
        }

        public TransitioningImageTotalCount build() {
            return new TransitioningImageTotalCount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitioningImageTotalCount> {
        public Builder targetStorageClass(String var1);

        public Builder targetStorageClass(LifecyclePolicyTargetStorageClass var1);

        public Builder imageTotalCount(Integer var1);
    }
}

