/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryScanningConfiguration;
import software.amazon.awssdk.services.ecr.model.RepositoryScanningConfigurationFailure;
import software.amazon.awssdk.services.ecr.model.RepositoryScanningConfigurationFailureListCopier;
import software.amazon.awssdk.services.ecr.model.RepositoryScanningConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetRepositoryScanningConfigurationResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, BatchGetRepositoryScanningConfigurationResponse> {
    private static final SdkField<List<RepositoryScanningConfiguration>> SCANNING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scanningConfigurations").getter(BatchGetRepositoryScanningConfigurationResponse.getter(BatchGetRepositoryScanningConfigurationResponse::scanningConfigurations)).setter(BatchGetRepositoryScanningConfigurationResponse.setter(Builder::scanningConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanningConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RepositoryScanningConfigurationFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(BatchGetRepositoryScanningConfigurationResponse.getter(BatchGetRepositoryScanningConfigurationResponse::failures)).setter(BatchGetRepositoryScanningConfigurationResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryScanningConfigurationFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANNING_CONFIGURATIONS_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetRepositoryScanningConfigurationResponse.memberNameToFieldInitializer();
    private final List<RepositoryScanningConfiguration> scanningConfigurations;
    private final List<RepositoryScanningConfigurationFailure> failures;

    private BatchGetRepositoryScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.scanningConfigurations = builder.scanningConfigurations;
        this.failures = builder.failures;
    }

    public final boolean hasScanningConfigurations() {
        return this.scanningConfigurations != null && !(this.scanningConfigurations instanceof SdkAutoConstructList);
    }

    public final List<RepositoryScanningConfiguration> scanningConfigurations() {
        return this.scanningConfigurations;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<RepositoryScanningConfigurationFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanningConfigurations() ? this.scanningConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRepositoryScanningConfigurationResponse)) {
            return false;
        }
        BatchGetRepositoryScanningConfigurationResponse other = (BatchGetRepositoryScanningConfigurationResponse)((Object)obj);
        return this.hasScanningConfigurations() == other.hasScanningConfigurations() && Objects.equals(this.scanningConfigurations(), other.scanningConfigurations()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetRepositoryScanningConfigurationResponse").add("ScanningConfigurations", this.hasScanningConfigurations() ? this.scanningConfigurations() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scanningConfigurations": {
                return Optional.ofNullable(clazz.cast(this.scanningConfigurations()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanningConfigurations", SCANNING_CONFIGURATIONS_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRepositoryScanningConfigurationResponse, T> g) {
        return obj -> g.apply((BatchGetRepositoryScanningConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<RepositoryScanningConfiguration> scanningConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<RepositoryScanningConfigurationFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRepositoryScanningConfigurationResponse model) {
            super(model);
            this.scanningConfigurations(model.scanningConfigurations);
            this.failures(model.failures);
        }

        public final List<RepositoryScanningConfiguration.Builder> getScanningConfigurations() {
            List<RepositoryScanningConfiguration.Builder> result = RepositoryScanningConfigurationListCopier.copyToBuilder(this.scanningConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanningConfigurations(Collection<RepositoryScanningConfiguration.BuilderImpl> scanningConfigurations) {
            this.scanningConfigurations = RepositoryScanningConfigurationListCopier.copyFromBuilder(scanningConfigurations);
        }

        @Override
        public final Builder scanningConfigurations(Collection<RepositoryScanningConfiguration> scanningConfigurations) {
            this.scanningConfigurations = RepositoryScanningConfigurationListCopier.copy(scanningConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanningConfigurations(RepositoryScanningConfiguration ... scanningConfigurations) {
            this.scanningConfigurations(Arrays.asList(scanningConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanningConfigurations(Consumer<RepositoryScanningConfiguration.Builder> ... scanningConfigurations) {
            this.scanningConfigurations(Stream.of(scanningConfigurations).map(c -> (RepositoryScanningConfiguration)((RepositoryScanningConfiguration.Builder)RepositoryScanningConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RepositoryScanningConfigurationFailure.Builder> getFailures() {
            List<RepositoryScanningConfigurationFailure.Builder> result = RepositoryScanningConfigurationFailureListCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<RepositoryScanningConfigurationFailure.BuilderImpl> failures) {
            this.failures = RepositoryScanningConfigurationFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<RepositoryScanningConfigurationFailure> failures) {
            this.failures = RepositoryScanningConfigurationFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(RepositoryScanningConfigurationFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<RepositoryScanningConfigurationFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (RepositoryScanningConfigurationFailure)((RepositoryScanningConfigurationFailure.Builder)RepositoryScanningConfigurationFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRepositoryScanningConfigurationResponse build() {
            return new BatchGetRepositoryScanningConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetRepositoryScanningConfigurationResponse> {
        public Builder scanningConfigurations(Collection<RepositoryScanningConfiguration> var1);

        public Builder scanningConfigurations(RepositoryScanningConfiguration ... var1);

        public Builder scanningConfigurations(Consumer<RepositoryScanningConfiguration.Builder> ... var1);

        public Builder failures(Collection<RepositoryScanningConfigurationFailure> var1);

        public Builder failures(RepositoryScanningConfigurationFailure ... var1);

        public Builder failures(Consumer<RepositoryScanningConfigurationFailure.Builder> ... var1);
    }
}

