/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePullThroughCacheRuleRequest extends EcrRequest implements
        ToCopyableBuilder<CreatePullThroughCacheRuleRequest.Builder, CreatePullThroughCacheRuleRequest> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(CreatePullThroughCacheRuleRequest::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistryUrl").getter(getter(CreatePullThroughCacheRuleRequest::upstreamRegistryUrl))
            .setter(setter(Builder::upstreamRegistryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build())
            .build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(CreatePullThroughCacheRuleRequest::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> UPSTREAM_REGISTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistry").getter(getter(CreatePullThroughCacheRuleRequest::upstreamRegistryAsString))
            .setter(setter(Builder::upstreamRegistry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistry").build()).build();

    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialArn").getter(getter(CreatePullThroughCacheRuleRequest::credentialArn))
            .setter(setter(Builder::credentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()).build();

    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customRoleArn").getter(getter(CreatePullThroughCacheRuleRequest::customRoleArn))
            .setter(setter(Builder::customRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()).build();

    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRepositoryPrefix").getter(getter(CreatePullThroughCacheRuleRequest::upstreamRepositoryPrefix))
            .setter(setter(Builder::upstreamRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD,
            UPSTREAM_REGISTRY_URL_FIELD, REGISTRY_ID_FIELD, UPSTREAM_REGISTRY_FIELD, CREDENTIAL_ARN_FIELD, CUSTOM_ROLE_ARN_FIELD,
            UPSTREAM_REPOSITORY_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ecrRepositoryPrefix;

    private final String upstreamRegistryUrl;

    private final String registryId;

    private final String upstreamRegistry;

    private final String credentialArn;

    private final String customRoleArn;

    private final String upstreamRepositoryPrefix;

    private CreatePullThroughCacheRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.registryId = builder.registryId;
        this.upstreamRegistry = builder.upstreamRegistry;
        this.credentialArn = builder.credentialArn;
        this.customRoleArn = builder.customRoleArn;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
    }

    /**
     * <p>
     * The repository name prefix to use when caching images from the source registry.
     * </p>
     * <important>
     * <p>
     * There is always an assumed <code>/</code> applied to the end of the prefix. If you specify
     * <code>ecr-public</code> as the prefix, Amazon ECR treats that as <code>ecr-public/</code>.
     * </p>
     * </important>
     * 
     * @return The repository name prefix to use when caching images from the source registry.</p> <important>
     *         <p>
     *         There is always an assumed <code>/</code> applied to the end of the prefix. If you specify
     *         <code>ecr-public</code> as the prefix, Amazon ECR treats that as <code>ecr-public/</code>.
     *         </p>
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The registry URL of the upstream public registry to use as the source for the pull through cache rule. The
     * following is the syntax to use for each supported upstream registry.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Amazon ECR (<code>ecr</code>) – <code>&lt;accountId&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon ECR Public (<code>ecr-public</code>) – <code>public.ecr.aws</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Docker Hub (<code>docker-hub</code>) – <code>registry-1.docker.io</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * GitHub Container Registry (<code>github-container-registry</code>) – <code>ghcr.io</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * GitLab Container Registry (<code>gitlab-container-registry</code>) – <code>registry.gitlab.com</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Kubernetes (<code>k8s</code>) – <code>registry.k8s.io</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Azure Container Registry (<code>azure-container-registry</code>) –
     * <code>&lt;custom&gt;.azurecr.io</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Quay (<code>quay</code>) – <code>quay.io</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The registry URL of the upstream public registry to use as the source for the pull through cache rule.
     *         The following is the syntax to use for each supported upstream registry.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Amazon ECR (<code>ecr</code>) – <code>&lt;accountId&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon ECR Public (<code>ecr-public</code>) – <code>public.ecr.aws</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Docker Hub (<code>docker-hub</code>) – <code>registry-1.docker.io</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GitHub Container Registry (<code>github-container-registry</code>) – <code>ghcr.io</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GitLab Container Registry (<code>gitlab-container-registry</code>) – <code>registry.gitlab.com</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Kubernetes (<code>k8s</code>) – <code>registry.k8s.io</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Microsoft Azure Container Registry (<code>azure-container-registry</code>) –
     *         <code>&lt;custom&gt;.azurecr.io</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Quay (<code>quay</code>) – <code>quay.io</code>
     *         </p>
     *         </li>
     */
    public final String upstreamRegistryUrl() {
        return upstreamRegistryUrl;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If you
     * do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry to create the pull through cache rule
     *         for. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the upstream registry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upstreamRegistry}
     * will return {@link UpstreamRegistry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #upstreamRegistryAsString}.
     * </p>
     * 
     * @return The name of the upstream registry.
     * @see UpstreamRegistry
     */
    public final UpstreamRegistry upstreamRegistry() {
        return UpstreamRegistry.fromValue(upstreamRegistry);
    }

    /**
     * <p>
     * The name of the upstream registry.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upstreamRegistry}
     * will return {@link UpstreamRegistry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #upstreamRegistryAsString}.
     * </p>
     * 
     * @return The name of the upstream registry.
     * @see UpstreamRegistry
     */
    public final String upstreamRegistryAsString() {
        return upstreamRegistry;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that identifies the credentials
     * to authenticate to the upstream registry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that identifies the
     *         credentials to authenticate to the upstream registry.
     */
    public final String credentialArn() {
        return credentialArn;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the IAM role to be assumed by Amazon ECR to authenticate to the ECR upstream
     * registry. This role must be in the same account as the registry that you are configuring.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the IAM role to be assumed by Amazon ECR to authenticate to the ECR
     *         upstream registry. This role must be in the same account as the registry that you are configuring.
     */
    public final String customRoleArn() {
        return customRoleArn;
    }

    /**
     * <p>
     * The repository name prefix of the upstream registry to match with the upstream repository name. When this field
     * isn't specified, Amazon ECR will use the <code>ROOT</code>.
     * </p>
     * 
     * @return The repository name prefix of the upstream registry to match with the upstream repository name. When this
     *         field isn't specified, Amazon ECR will use the <code>ROOT</code>.
     */
    public final String upstreamRepositoryPrefix() {
        return upstreamRepositoryPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(customRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRepositoryPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullThroughCacheRuleRequest)) {
            return false;
        }
        CreatePullThroughCacheRuleRequest other = (CreatePullThroughCacheRuleRequest) obj;
        return Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(upstreamRegistryUrl(), other.upstreamRegistryUrl())
                && Objects.equals(registryId(), other.registryId())
                && Objects.equals(upstreamRegistryAsString(), other.upstreamRegistryAsString())
                && Objects.equals(credentialArn(), other.credentialArn())
                && Objects.equals(customRoleArn(), other.customRoleArn())
                && Objects.equals(upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePullThroughCacheRuleRequest").add("EcrRepositoryPrefix", ecrRepositoryPrefix())
                .add("UpstreamRegistryUrl", upstreamRegistryUrl()).add("RegistryId", registryId())
                .add("UpstreamRegistry", upstreamRegistryAsString()).add("CredentialArn", credentialArn())
                .add("CustomRoleArn", customRoleArn()).add("UpstreamRepositoryPrefix", upstreamRepositoryPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "upstreamRegistryUrl":
            return Optional.ofNullable(clazz.cast(upstreamRegistryUrl()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "upstreamRegistry":
            return Optional.ofNullable(clazz.cast(upstreamRegistryAsString()));
        case "credentialArn":
            return Optional.ofNullable(clazz.cast(credentialArn()));
        case "customRoleArn":
            return Optional.ofNullable(clazz.cast(customRoleArn()));
        case "upstreamRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(upstreamRepositoryPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("upstreamRegistry", UPSTREAM_REGISTRY_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePullThroughCacheRuleRequest, T> g) {
        return obj -> g.apply((CreatePullThroughCacheRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePullThroughCacheRuleRequest> {
        /**
         * <p>
         * The repository name prefix to use when caching images from the source registry.
         * </p>
         * <important>
         * <p>
         * There is always an assumed <code>/</code> applied to the end of the prefix. If you specify
         * <code>ecr-public</code> as the prefix, Amazon ECR treats that as <code>ecr-public/</code>.
         * </p>
         * </important>
         * 
         * @param ecrRepositoryPrefix
         *        The repository name prefix to use when caching images from the source registry.</p> <important>
         *        <p>
         *        There is always an assumed <code>/</code> applied to the end of the prefix. If you specify
         *        <code>ecr-public</code> as the prefix, Amazon ECR treats that as <code>ecr-public/</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The registry URL of the upstream public registry to use as the source for the pull through cache rule. The
         * following is the syntax to use for each supported upstream registry.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Amazon ECR (<code>ecr</code>) – <code>&lt;accountId&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon ECR Public (<code>ecr-public</code>) – <code>public.ecr.aws</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Docker Hub (<code>docker-hub</code>) – <code>registry-1.docker.io</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * GitHub Container Registry (<code>github-container-registry</code>) – <code>ghcr.io</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * GitLab Container Registry (<code>gitlab-container-registry</code>) – <code>registry.gitlab.com</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Kubernetes (<code>k8s</code>) – <code>registry.k8s.io</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Microsoft Azure Container Registry (<code>azure-container-registry</code>) –
         * <code>&lt;custom&gt;.azurecr.io</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Quay (<code>quay</code>) – <code>quay.io</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param upstreamRegistryUrl
         *        The registry URL of the upstream public registry to use as the source for the pull through cache rule.
         *        The following is the syntax to use for each supported upstream registry.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Amazon ECR (<code>ecr</code>) – <code>&lt;accountId&gt;.dkr.ecr.&lt;region&gt;.amazonaws.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon ECR Public (<code>ecr-public</code>) – <code>public.ecr.aws</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Docker Hub (<code>docker-hub</code>) – <code>registry-1.docker.io</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GitHub Container Registry (<code>github-container-registry</code>) – <code>ghcr.io</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GitLab Container Registry (<code>gitlab-container-registry</code>) – <code>registry.gitlab.com</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Kubernetes (<code>k8s</code>) – <code>registry.k8s.io</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Microsoft Azure Container Registry (<code>azure-container-registry</code>) –
         *        <code>&lt;custom&gt;.azurecr.io</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Quay (<code>quay</code>) – <code>quay.io</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRegistryUrl(String upstreamRegistryUrl);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry to create the pull through cache rule for. If
         * you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry to create the pull through cache rule
         *        for. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the upstream registry.
         * </p>
         * 
         * @param upstreamRegistry
         *        The name of the upstream registry.
         * @see UpstreamRegistry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpstreamRegistry
         */
        Builder upstreamRegistry(String upstreamRegistry);

        /**
         * <p>
         * The name of the upstream registry.
         * </p>
         * 
         * @param upstreamRegistry
         *        The name of the upstream registry.
         * @see UpstreamRegistry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpstreamRegistry
         */
        Builder upstreamRegistry(UpstreamRegistry upstreamRegistry);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that identifies the
         * credentials to authenticate to the upstream registry.
         * </p>
         * 
         * @param credentialArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager secret that identifies the
         *        credentials to authenticate to the upstream registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialArn(String credentialArn);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the IAM role to be assumed by Amazon ECR to authenticate to the ECR upstream
         * registry. This role must be in the same account as the registry that you are configuring.
         * </p>
         * 
         * @param customRoleArn
         *        Amazon Resource Name (ARN) of the IAM role to be assumed by Amazon ECR to authenticate to the ECR
         *        upstream registry. This role must be in the same account as the registry that you are configuring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRoleArn(String customRoleArn);

        /**
         * <p>
         * The repository name prefix of the upstream registry to match with the upstream repository name. When this
         * field isn't specified, Amazon ECR will use the <code>ROOT</code>.
         * </p>
         * 
         * @param upstreamRepositoryPrefix
         *        The repository name prefix of the upstream registry to match with the upstream repository name. When
         *        this field isn't specified, Amazon ECR will use the <code>ROOT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String ecrRepositoryPrefix;

        private String upstreamRegistryUrl;

        private String registryId;

        private String upstreamRegistry;

        private String credentialArn;

        private String customRoleArn;

        private String upstreamRepositoryPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePullThroughCacheRuleRequest model) {
            super(model);
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            upstreamRegistryUrl(model.upstreamRegistryUrl);
            registryId(model.registryId);
            upstreamRegistry(model.upstreamRegistry);
            credentialArn(model.credentialArn);
            customRoleArn(model.customRoleArn);
            upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getUpstreamRegistry() {
            return upstreamRegistry;
        }

        public final void setUpstreamRegistry(String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
        }

        @Override
        public final Builder upstreamRegistry(String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
            return this;
        }

        @Override
        public final Builder upstreamRegistry(UpstreamRegistry upstreamRegistry) {
            this.upstreamRegistry(upstreamRegistry == null ? null : upstreamRegistry.toString());
            return this;
        }

        public final String getCredentialArn() {
            return credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        public final String getCustomRoleArn() {
            return customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePullThroughCacheRuleRequest build() {
            return new CreatePullThroughCacheRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
