/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ImageTagListCopier;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyRuleAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyPreviewResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyPreviewResult> {
    private static final SdkField<List<String>> IMAGE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imageTags").getter(LifecyclePolicyPreviewResult.getter(LifecyclePolicyPreviewResult::imageTags)).setter(LifecyclePolicyPreviewResult.setter(Builder::imageTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(LifecyclePolicyPreviewResult.getter(LifecyclePolicyPreviewResult::imageDigest)).setter(LifecyclePolicyPreviewResult.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<Instant> IMAGE_PUSHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("imagePushedAt").getter(LifecyclePolicyPreviewResult.getter(LifecyclePolicyPreviewResult::imagePushedAt)).setter(LifecyclePolicyPreviewResult.setter(Builder::imagePushedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePushedAt").build()}).build();
    private static final SdkField<LifecyclePolicyRuleAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(LifecyclePolicyPreviewResult.getter(LifecyclePolicyPreviewResult::action)).setter(LifecyclePolicyPreviewResult.setter(Builder::action)).constructor(LifecyclePolicyRuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Integer> APPLIED_RULE_PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("appliedRulePriority").getter(LifecyclePolicyPreviewResult.getter(LifecyclePolicyPreviewResult::appliedRulePriority)).setter(LifecyclePolicyPreviewResult.setter(Builder::appliedRulePriority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedRulePriority").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TAGS_FIELD, IMAGE_DIGEST_FIELD, IMAGE_PUSHED_AT_FIELD, ACTION_FIELD, APPLIED_RULE_PRIORITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("imageTags", IMAGE_TAGS_FIELD);
            this.put("imageDigest", IMAGE_DIGEST_FIELD);
            this.put("imagePushedAt", IMAGE_PUSHED_AT_FIELD);
            this.put("action", ACTION_FIELD);
            this.put("appliedRulePriority", APPLIED_RULE_PRIORITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> imageTags;
    private final String imageDigest;
    private final Instant imagePushedAt;
    private final LifecyclePolicyRuleAction action;
    private final Integer appliedRulePriority;

    private LifecyclePolicyPreviewResult(BuilderImpl builder) {
        this.imageTags = builder.imageTags;
        this.imageDigest = builder.imageDigest;
        this.imagePushedAt = builder.imagePushedAt;
        this.action = builder.action;
        this.appliedRulePriority = builder.appliedRulePriority;
    }

    public final boolean hasImageTags() {
        return this.imageTags != null && !(this.imageTags instanceof SdkAutoConstructList);
    }

    public final List<String> imageTags() {
        return this.imageTags;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public final LifecyclePolicyRuleAction action() {
        return this.action;
    }

    public final Integer appliedRulePriority() {
        return this.appliedRulePriority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageTags() ? this.imageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePushedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedRulePriority());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyPreviewResult)) {
            return false;
        }
        LifecyclePolicyPreviewResult other = (LifecyclePolicyPreviewResult)obj;
        return this.hasImageTags() == other.hasImageTags() && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.imagePushedAt(), other.imagePushedAt()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.appliedRulePriority(), other.appliedRulePriority());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyPreviewResult").add("ImageTags", this.hasImageTags() ? this.imageTags() : null).add("ImageDigest", (Object)this.imageDigest()).add("ImagePushedAt", (Object)this.imagePushedAt()).add("Action", (Object)this.action()).add("AppliedRulePriority", (Object)this.appliedRulePriority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageTags": {
                return Optional.ofNullable(clazz.cast(this.imageTags()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "imagePushedAt": {
                return Optional.ofNullable(clazz.cast(this.imagePushedAt()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "appliedRulePriority": {
                return Optional.ofNullable(clazz.cast(this.appliedRulePriority()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyPreviewResult, T> g) {
        return obj -> g.apply((LifecyclePolicyPreviewResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> imageTags = DefaultSdkAutoConstructList.getInstance();
        private String imageDigest;
        private Instant imagePushedAt;
        private LifecyclePolicyRuleAction action;
        private Integer appliedRulePriority;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyPreviewResult model) {
            this.imageTags(model.imageTags);
            this.imageDigest(model.imageDigest);
            this.imagePushedAt(model.imagePushedAt);
            this.action(model.action);
            this.appliedRulePriority(model.appliedRulePriority);
        }

        public final Collection<String> getImageTags() {
            if (this.imageTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.imageTags;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final LifecyclePolicyRuleAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(LifecyclePolicyRuleAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(LifecyclePolicyRuleAction action) {
            this.action = action;
            return this;
        }

        public final Integer getAppliedRulePriority() {
            return this.appliedRulePriority;
        }

        public final void setAppliedRulePriority(Integer appliedRulePriority) {
            this.appliedRulePriority = appliedRulePriority;
        }

        @Override
        public final Builder appliedRulePriority(Integer appliedRulePriority) {
            this.appliedRulePriority = appliedRulePriority;
            return this;
        }

        public LifecyclePolicyPreviewResult build() {
            return new LifecyclePolicyPreviewResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyPreviewResult> {
        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imageDigest(String var1);

        public Builder imagePushedAt(Instant var1);

        public Builder action(LifecyclePolicyRuleAction var1);

        default public Builder action(Consumer<LifecyclePolicyRuleAction.Builder> action) {
            return this.action((LifecyclePolicyRuleAction)((LifecyclePolicyRuleAction.Builder)LifecyclePolicyRuleAction.builder().applyMutation(action)).build());
        }

        public Builder appliedRulePriority(Integer var1);
    }
}

