/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageReplicationStatusRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, DescribeImageReplicationStatusRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(DescribeImageReplicationStatusRequest.getter(DescribeImageReplicationStatusRequest::repositoryName)).setter(DescribeImageReplicationStatusRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageId").getter(DescribeImageReplicationStatusRequest.getter(DescribeImageReplicationStatusRequest::imageId)).setter(DescribeImageReplicationStatusRequest.setter(Builder::imageId)).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DescribeImageReplicationStatusRequest.getter(DescribeImageReplicationStatusRequest::registryId)).setter(DescribeImageReplicationStatusRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, REGISTRY_ID_FIELD));
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final String registryId;

    private DescribeImageReplicationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.registryId = builder.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ImageIdentifier imageId() {
        return this.imageId;
    }

    public final String registryId() {
        return this.registryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReplicationStatusRequest)) {
            return false;
        }
        DescribeImageReplicationStatusRequest other = (DescribeImageReplicationStatusRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.registryId(), other.registryId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageReplicationStatusRequest").add("RepositoryName", (Object)this.repositoryName()).add("ImageId", (Object)this.imageId()).add("RegistryId", (Object)this.registryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReplicationStatusRequest, T> g) {
        return obj -> g.apply((DescribeImageReplicationStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String repositoryName;
        private ImageIdentifier imageId;
        private String registryId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReplicationStatusRequest model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.registryId(model.registryId);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImageReplicationStatusRequest build() {
            return new DescribeImageReplicationStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageReplicationStatusRequest> {
        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation(imageId)).build());
        }

        public Builder registryId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

