/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LayerFailureCode {
    INVALID_LAYER_DIGEST("InvalidLayerDigest"),
    MISSING_LAYER_DIGEST("MissingLayerDigest"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LayerFailureCode> VALUE_MAP;
    private final String value;

    private LayerFailureCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LayerFailureCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LayerFailureCode> knownValues() {
        EnumSet<LayerFailureCode> knownValues = EnumSet.allOf(LayerFailureCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LayerFailureCode.class, LayerFailureCode::toString);
    }
}

