/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.EnhancedImageScanFinding;
import software.amazon.awssdk.services.ecr.model.ImageScanFinding;

public class DescribeImageScanFindingsIterable
implements SdkIterable<DescribeImageScanFindingsResponse> {
    private final EcrClient client;
    private final DescribeImageScanFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImageScanFindingsIterable(EcrClient client, DescribeImageScanFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImageScanFindingsResponseFetcher();
    }

    public Iterator<DescribeImageScanFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageScanFinding> findings() {
        Function<DescribeImageScanFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageScanFindings() != null && response.imageScanFindings().findings() != null) {
                return response.imageScanFindings().findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<EnhancedImageScanFinding> enhancedFindings() {
        Function<DescribeImageScanFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageScanFindings() != null && response.imageScanFindings().enhancedFindings() != null) {
                return response.imageScanFindings().enhancedFindings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImageScanFindingsResponseFetcher
    implements SyncPageFetcher<DescribeImageScanFindingsResponse> {
        private DescribeImageScanFindingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageScanFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImageScanFindingsResponse nextPage(DescribeImageScanFindingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageScanFindingsIterable.this.client.describeImageScanFindings(DescribeImageScanFindingsIterable.this.firstRequest);
            }
            return DescribeImageScanFindingsIterable.this.client.describeImageScanFindings((DescribeImageScanFindingsRequest)((Object)DescribeImageScanFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

