/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.PullThroughCacheRuleRepositoryPrefixListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePullThroughCacheRulesRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, DescribePullThroughCacheRulesRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DescribePullThroughCacheRulesRequest.getter(DescribePullThroughCacheRulesRequest::registryId)).setter(DescribePullThroughCacheRulesRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<List<String>> ECR_REPOSITORY_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ecrRepositoryPrefixes").getter(DescribePullThroughCacheRulesRequest.getter(DescribePullThroughCacheRulesRequest::ecrRepositoryPrefixes)).setter(DescribePullThroughCacheRulesRequest.setter(Builder::ecrRepositoryPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefixes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribePullThroughCacheRulesRequest.getter(DescribePullThroughCacheRulesRequest::nextToken)).setter(DescribePullThroughCacheRulesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribePullThroughCacheRulesRequest.getter(DescribePullThroughCacheRulesRequest::maxResults)).setter(DescribePullThroughCacheRulesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, ECR_REPOSITORY_PREFIXES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String registryId;
    private final List<String> ecrRepositoryPrefixes;
    private final String nextToken;
    private final Integer maxResults;

    private DescribePullThroughCacheRulesRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.ecrRepositoryPrefixes = builder.ecrRepositoryPrefixes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final boolean hasEcrRepositoryPrefixes() {
        return this.ecrRepositoryPrefixes != null && !(this.ecrRepositoryPrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> ecrRepositoryPrefixes() {
        return this.ecrRepositoryPrefixes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcrRepositoryPrefixes() ? this.ecrRepositoryPrefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePullThroughCacheRulesRequest)) {
            return false;
        }
        DescribePullThroughCacheRulesRequest other = (DescribePullThroughCacheRulesRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && this.hasEcrRepositoryPrefixes() == other.hasEcrRepositoryPrefixes() && Objects.equals(this.ecrRepositoryPrefixes(), other.ecrRepositoryPrefixes()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePullThroughCacheRulesRequest").add("RegistryId", (Object)this.registryId()).add("EcrRepositoryPrefixes", this.hasEcrRepositoryPrefixes() ? this.ecrRepositoryPrefixes() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "ecrRepositoryPrefixes": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryPrefixes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePullThroughCacheRulesRequest, T> g) {
        return obj -> g.apply((DescribePullThroughCacheRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private List<String> ecrRepositoryPrefixes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePullThroughCacheRulesRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.ecrRepositoryPrefixes(model.ecrRepositoryPrefixes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final Collection<String> getEcrRepositoryPrefixes() {
            if (this.ecrRepositoryPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ecrRepositoryPrefixes;
        }

        public final void setEcrRepositoryPrefixes(Collection<String> ecrRepositoryPrefixes) {
            this.ecrRepositoryPrefixes = PullThroughCacheRuleRepositoryPrefixListCopier.copy(ecrRepositoryPrefixes);
        }

        @Override
        @Transient
        public final Builder ecrRepositoryPrefixes(Collection<String> ecrRepositoryPrefixes) {
            this.ecrRepositoryPrefixes = PullThroughCacheRuleRepositoryPrefixListCopier.copy(ecrRepositoryPrefixes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ecrRepositoryPrefixes(String ... ecrRepositoryPrefixes) {
            this.ecrRepositoryPrefixes(Arrays.asList(ecrRepositoryPrefixes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePullThroughCacheRulesRequest build() {
            return new DescribePullThroughCacheRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePullThroughCacheRulesRequest> {
        public Builder registryId(String var1);

        public Builder ecrRepositoryPrefixes(Collection<String> var1);

        public Builder ecrRepositoryPrefixes(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

