/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.ScanningConfigurationFailureCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryScanningConfigurationFailure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryScanningConfigurationFailure> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(RepositoryScanningConfigurationFailure.getter(RepositoryScanningConfigurationFailure::repositoryName)).setter(RepositoryScanningConfigurationFailure.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(RepositoryScanningConfigurationFailure.getter(RepositoryScanningConfigurationFailure::failureCodeAsString)).setter(RepositoryScanningConfigurationFailure.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(RepositoryScanningConfigurationFailure.getter(RepositoryScanningConfigurationFailure::failureReason)).setter(RepositoryScanningConfigurationFailure.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String repositoryName;
    private final String failureCode;
    private final String failureReason;

    private RepositoryScanningConfigurationFailure(BuilderImpl builder) {
        this.repositoryName = builder.repositoryName;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ScanningConfigurationFailureCode failureCode() {
        return ScanningConfigurationFailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryScanningConfigurationFailure)) {
            return false;
        }
        RepositoryScanningConfigurationFailure other = (RepositoryScanningConfigurationFailure)obj;
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryScanningConfigurationFailure").add("RepositoryName", (Object)this.repositoryName()).add("FailureCode", (Object)this.failureCodeAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryScanningConfigurationFailure, T> g) {
        return obj -> g.apply((RepositoryScanningConfigurationFailure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryName;
        private String failureCode;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryScanningConfigurationFailure model) {
            this.repositoryName(model.repositoryName);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        @Transient
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        @Transient
        public final Builder failureCode(ScanningConfigurationFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public RepositoryScanningConfigurationFailure build() {
            return new RepositoryScanningConfigurationFailure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryScanningConfigurationFailure> {
        public Builder repositoryName(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(ScanningConfigurationFailureCode var1);

        public Builder failureReason(String var1);
    }
}

