/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDownloadUrlForLayerRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, GetDownloadUrlForLayerRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(GetDownloadUrlForLayerRequest.getter(GetDownloadUrlForLayerRequest::registryId)).setter(GetDownloadUrlForLayerRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(GetDownloadUrlForLayerRequest.getter(GetDownloadUrlForLayerRequest::repositoryName)).setter(GetDownloadUrlForLayerRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layerDigest").getter(GetDownloadUrlForLayerRequest.getter(GetDownloadUrlForLayerRequest::layerDigest)).setter(GetDownloadUrlForLayerRequest.setter(Builder::layerDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, LAYER_DIGEST_FIELD));
    private final String registryId;
    private final String repositoryName;
    private final String layerDigest;

    private GetDownloadUrlForLayerRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.layerDigest = builder.layerDigest;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String layerDigest() {
        return this.layerDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDownloadUrlForLayerRequest)) {
            return false;
        }
        GetDownloadUrlForLayerRequest other = (GetDownloadUrlForLayerRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.layerDigest(), other.layerDigest());
    }

    public final String toString() {
        return ToString.builder((String)"GetDownloadUrlForLayerRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("LayerDigest", (Object)this.layerDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "layerDigest": {
                return Optional.ofNullable(clazz.cast(this.layerDigest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDownloadUrlForLayerRequest, T> g) {
        return obj -> g.apply((GetDownloadUrlForLayerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDownloadUrlForLayerRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.layerDigest(model.layerDigest);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        @Transient
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        @Transient
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDownloadUrlForLayerRequest build() {
            return new GetDownloadUrlForLayerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDownloadUrlForLayerRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder layerDigest(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

