/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.LayerFailureCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayerFailure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayerFailure> {
    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layerDigest").getter(LayerFailure.getter(LayerFailure::layerDigest)).setter(LayerFailure.setter(Builder::layerDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(LayerFailure.getter(LayerFailure::failureCodeAsString)).setter(LayerFailure.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(LayerFailure.getter(LayerFailure::failureReason)).setter(LayerFailure.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_DIGEST_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String layerDigest;
    private final String failureCode;
    private final String failureReason;

    private LayerFailure(BuilderImpl builder) {
        this.layerDigest = builder.layerDigest;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    public final String layerDigest() {
        return this.layerDigest;
    }

    public final LayerFailureCode failureCode() {
        return LayerFailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerFailure)) {
            return false;
        }
        LayerFailure other = (LayerFailure)obj;
        return Objects.equals(this.layerDigest(), other.layerDigest()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"LayerFailure").add("LayerDigest", (Object)this.layerDigest()).add("FailureCode", (Object)this.failureCodeAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layerDigest": {
                return Optional.ofNullable(clazz.cast(this.layerDigest()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayerFailure, T> g) {
        return obj -> g.apply((LayerFailure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String layerDigest;
        private String failureCode;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerFailure model) {
            this.layerDigest(model.layerDigest);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(LayerFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public LayerFailure build() {
            return new LayerFailure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayerFailure> {
        public Builder layerDigest(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(LayerFailureCode var1);

        public Builder failureReason(String var1);
    }
}

