/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::registryId)).setter(Image.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::repositoryName)).setter(Image.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Image.getter(Image::imageId)).setter(Image.setter(Builder::imageId)).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::imageManifest)).setter(Image.setter(Builder::imageManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifest").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Image.getter(Image::imageManifestMediaType)).setter(Image.setter(Builder::imageManifestMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, IMAGE_MANIFEST_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String registryId;
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final String imageManifest;
    private final String imageManifestMediaType;

    private Image(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.imageManifest = builder.imageManifest;
        this.imageManifestMediaType = builder.imageManifestMediaType;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public ImageIdentifier imageId() {
        return this.imageId;
    }

    public String imageManifest() {
        return this.imageManifest;
    }

    public String imageManifestMediaType() {
        return this.imageManifestMediaType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifestMediaType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageManifest(), other.imageManifest()) && Objects.equals(this.imageManifestMediaType(), other.imageManifestMediaType());
    }

    public String toString() {
        return ToString.builder((String)"Image").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageId", (Object)this.imageId()).add("ImageManifest", (Object)this.imageManifest()).add("ImageManifestMediaType", (Object)this.imageManifestMediaType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "imageManifest": {
                return Optional.ofNullable(clazz.cast(this.imageManifest()));
            }
            case "imageManifestMediaType": {
                return Optional.ofNullable(clazz.cast(this.imageManifestMediaType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private ImageIdentifier imageId;
        private String imageManifest;
        private String imageManifestMediaType;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.imageManifest(model.imageManifest);
            this.imageManifestMediaType(model.imageManifestMediaType);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        public final String getImageManifest() {
            return this.imageManifest;
        }

        @Override
        public final Builder imageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
            return this;
        }

        public final void setImageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
        }

        public final String getImageManifestMediaType() {
            return this.imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation(imageId)).build());
        }

        public Builder imageManifest(String var1);

        public Builder imageManifestMediaType(String var1);
    }
}

