/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImagesResponse extends EcrResponse implements
        ToCopyableBuilder<ListImagesResponse.Builder, ListImagesResponse> {
    private static final SdkField<List<ImageIdentifier>> IMAGE_IDS_FIELD = SdkField
            .<List<ImageIdentifier>> builder(MarshallingType.LIST)
            .getter(getter(ListImagesResponse::imageIds))
            .setter(setter(Builder::imageIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListImagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImageIdentifier> imageIds;

    private final String nextToken;

    private ListImagesResponse(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ImageIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasImageIds() {
        return imageIds != null && !(imageIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of image IDs for the requested repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImageIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of image IDs for the requested repository.
     */
    public List<ImageIdentifier> imageIds() {
        return imageIds;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListImages</code> request. When the results of a
     * <code>ListImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page
     * of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListImages</code> request. When the results
     *         of a <code>ListImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve
     *         the next page of results. This value is <code>null</code> when there are no more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagesResponse)) {
            return false;
        }
        ListImagesResponse other = (ListImagesResponse) obj;
        return Objects.equals(imageIds(), other.imageIds()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListImagesResponse").add("ImageIds", imageIds()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageIds":
            return Optional.ofNullable(clazz.cast(imageIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImagesResponse, T> g) {
        return obj -> g.apply((ListImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListImagesResponse> {
        /**
         * <p>
         * The list of image IDs for the requested repository.
         * </p>
         * 
         * @param imageIds
         *        The list of image IDs for the requested repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(Collection<ImageIdentifier> imageIds);

        /**
         * <p>
         * The list of image IDs for the requested repository.
         * </p>
         * 
         * @param imageIds
         *        The list of image IDs for the requested repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageIds(ImageIdentifier... imageIds);

        /**
         * <p>
         * The list of image IDs for the requested repository.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<ImageIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #imageIds(List<ImageIdentifier>)}.
         * 
         * @param imageIds
         *        a consumer that will call methods on {@link List<ImageIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageIds(List<ImageIdentifier>)
         */
        Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListImages</code> request. When the results of
         * a <code>ListImages</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next
         * page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListImages</code> request. When the
         *        results of a <code>ListImages</code> request exceed <code>maxResults</code>, this value can be used to
         *        retrieve the next page of results. This value is <code>null</code> when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<ImageIdentifier> imageIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagesResponse model) {
            super(model);
            imageIds(model.imageIds);
            nextToken(model.nextToken);
        }

        public final Collection<ImageIdentifier.Builder> getImageIds() {
            return imageIds != null ? imageIds.stream().map(ImageIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier... imageIds) {
            imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder>... imageIds) {
            imageIds(Stream.of(imageIds).map(c -> ImageIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListImagesResponse build() {
            return new ListImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
