/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a filter on a <a>DescribeImages</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImagesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeImagesFilter.Builder, DescribeImagesFilter> {
    private static final SdkField<String> TAG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeImagesFilter::tagStatusAsString)).setter(setter(Builder::tagStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tagStatus;

    private DescribeImagesFilter(BuilderImpl builder) {
        this.tagStatus = builder.tagStatus;
    }

    /**
     * <p>
     * The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on whether
     * they are <code>TAGGED</code> or <code>UNTAGGED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tagStatus} will
     * return {@link TagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tagStatusAsString}.
     * </p>
     * 
     * @return The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on
     *         whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.
     * @see TagStatus
     */
    public TagStatus tagStatus() {
        return TagStatus.fromValue(tagStatus);
    }

    /**
     * <p>
     * The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on whether
     * they are <code>TAGGED</code> or <code>UNTAGGED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tagStatus} will
     * return {@link TagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tagStatusAsString}.
     * </p>
     * 
     * @return The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on
     *         whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.
     * @see TagStatus
     */
    public String tagStatusAsString() {
        return tagStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesFilter)) {
            return false;
        }
        DescribeImagesFilter other = (DescribeImagesFilter) obj;
        return Objects.equals(tagStatusAsString(), other.tagStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImagesFilter").add("TagStatus", tagStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tagStatus":
            return Optional.ofNullable(clazz.cast(tagStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImagesFilter, T> g) {
        return obj -> g.apply((DescribeImagesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeImagesFilter> {
        /**
         * <p>
         * The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on
         * whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.
         * </p>
         * 
         * @param tagStatus
         *        The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based
         *        on whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.
         * @see TagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagStatus
         */
        Builder tagStatus(String tagStatus);

        /**
         * <p>
         * The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based on
         * whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.
         * </p>
         * 
         * @param tagStatus
         *        The tag status with which to filter your <a>DescribeImages</a> results. You can filter results based
         *        on whether they are <code>TAGGED</code> or <code>UNTAGGED</code>.
         * @see TagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagStatus
         */
        Builder tagStatus(TagStatus tagStatus);
    }

    static final class BuilderImpl implements Builder {
        private String tagStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesFilter model) {
            tagStatus(model.tagStatus);
        }

        public final String getTagStatus() {
            return tagStatus;
        }

        @Override
        public final Builder tagStatus(String tagStatus) {
            this.tagStatus = tagStatus;
            return this;
        }

        @Override
        public final Builder tagStatus(TagStatus tagStatus) {
            this.tagStatus(tagStatus == null ? null : tagStatus.toString());
            return this;
        }

        public final void setTagStatus(String tagStatus) {
            this.tagStatus = tagStatus;
        }

        @Override
        public DescribeImagesFilter build() {
            return new DescribeImagesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
