/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitiateLayerUploadResponse extends EcrResponse implements
        ToCopyableBuilder<InitiateLayerUploadResponse.Builder, InitiateLayerUploadResponse> {
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InitiateLayerUploadResponse::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<Long> PART_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(InitiateLayerUploadResponse::partSize)).setter(setter(Builder::partSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_ID_FIELD,
            PART_SIZE_FIELD));

    private final String uploadId;

    private final Long partSize;

    private InitiateLayerUploadResponse(BuilderImpl builder) {
        super(builder);
        this.uploadId = builder.uploadId;
        this.partSize = builder.partSize;
    }

    /**
     * <p>
     * The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and
     * <a>CompleteLayerUpload</a> operations.
     * </p>
     * 
     * @return The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and
     *         <a>CompleteLayerUpload</a> operations.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The size, in bytes, that Amazon ECR expects future layer part uploads to be.
     * </p>
     * 
     * @return The size, in bytes, that Amazon ECR expects future layer part uploads to be.
     */
    public Long partSize() {
        return partSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(partSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateLayerUploadResponse)) {
            return false;
        }
        InitiateLayerUploadResponse other = (InitiateLayerUploadResponse) obj;
        return Objects.equals(uploadId(), other.uploadId()) && Objects.equals(partSize(), other.partSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InitiateLayerUploadResponse").add("UploadId", uploadId()).add("PartSize", partSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "partSize":
            return Optional.ofNullable(clazz.cast(partSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateLayerUploadResponse, T> g) {
        return obj -> g.apply((InitiateLayerUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, InitiateLayerUploadResponse> {
        /**
         * <p>
         * The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and
         * <a>CompleteLayerUpload</a> operations.
         * </p>
         * 
         * @param uploadId
         *        The upload ID for the layer upload. This parameter is passed to further <a>UploadLayerPart</a> and
         *        <a>CompleteLayerUpload</a> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The size, in bytes, that Amazon ECR expects future layer part uploads to be.
         * </p>
         * 
         * @param partSize
         *        The size, in bytes, that Amazon ECR expects future layer part uploads to be.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partSize(Long partSize);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private String uploadId;

        private Long partSize;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateLayerUploadResponse model) {
            super(model);
            uploadId(model.uploadId);
            partSize(model.partSize);
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getPartSize() {
            return partSize;
        }

        @Override
        public final Builder partSize(Long partSize) {
            this.partSize = partSize;
            return this;
        }

        public final void setPartSize(Long partSize) {
            this.partSize = partSize;
        }

        @Override
        public InitiateLayerUploadResponse build() {
            return new InitiateLayerUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
