/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthorizationTokenResponse extends EcrResponse implements
        ToCopyableBuilder<GetAuthorizationTokenResponse.Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<List<AuthorizationData>> AUTHORIZATION_DATA_FIELD = SdkField
            .<List<AuthorizationData>> builder(MarshallingType.LIST)
            .getter(getter(GetAuthorizationTokenResponse::authorizationData))
            .setter(setter(Builder::authorizationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationData").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthorizationData> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizationData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_DATA_FIELD));

    private final List<AuthorizationData> authorizationData;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationData = builder.authorizationData;
    }

    /**
     * Returns true if the AuthorizationData property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAuthorizationData() {
        return authorizationData != null && !(authorizationData instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuthorizationData()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
     *         request.
     */
    public List<AuthorizationData> authorizationData() {
        return authorizationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizationData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse) obj;
        return Objects.equals(authorizationData(), other.authorizationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAuthorizationTokenResponse").add("AuthorizationData", authorizationData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationData":
            return Optional.ofNullable(clazz.cast(authorizationData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        /**
         * <p>
         * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
         * request.
         * </p>
         * 
         * @param authorizationData
         *        A list of authorization token data objects that correspond to the <code>registryIds</code> values in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationData(Collection<AuthorizationData> authorizationData);

        /**
         * <p>
         * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
         * request.
         * </p>
         * 
         * @param authorizationData
         *        A list of authorization token data objects that correspond to the <code>registryIds</code> values in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationData(AuthorizationData... authorizationData);

        /**
         * <p>
         * A list of authorization token data objects that correspond to the <code>registryIds</code> values in the
         * request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuthorizationData>.Builder} avoiding the
         * need to create one manually via {@link List<AuthorizationData>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuthorizationData>.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizationData(List<AuthorizationData>)}.
         * 
         * @param authorizationData
         *        a consumer that will call methods on {@link List<AuthorizationData>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationData(List<AuthorizationData>)
         */
        Builder authorizationData(Consumer<AuthorizationData.Builder>... authorizationData);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<AuthorizationData> authorizationData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            authorizationData(model.authorizationData);
        }

        public final Collection<AuthorizationData.Builder> getAuthorizationData() {
            return authorizationData != null ? authorizationData.stream().map(AuthorizationData::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authorizationData(Collection<AuthorizationData> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copy(authorizationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(AuthorizationData... authorizationData) {
            authorizationData(Arrays.asList(authorizationData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(Consumer<AuthorizationData.Builder>... authorizationData) {
            authorizationData(Stream.of(authorizationData).map(c -> AuthorizationData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAuthorizationData(Collection<AuthorizationData.BuilderImpl> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copyFromBuilder(authorizationData);
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
