/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRepositoryRequest extends EcrRequest implements
        ToCopyableBuilder<CreateRepositoryRequest.Builder, CreateRepositoryRequest> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRepositoryRequest::repositoryName)).setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateRepositoryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRepositoryRequest::imageTagMutabilityAsString)).setter(setter(Builder::imageTagMutability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build())
            .build();

    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField
            .<ImageScanningConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRepositoryRequest::imageScanningConfiguration))
            .setter(setter(Builder::imageScanningConfiguration))
            .constructor(ImageScanningConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD,
            TAGS_FIELD, IMAGE_TAG_MUTABILITY_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD));

    private final String repositoryName;

    private final List<Tag> tags;

    private final String imageTagMutability;

    private final ImageScanningConfiguration imageScanningConfiguration;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.tags = builder.tags;
        this.imageTagMutability = builder.imageTagMutability;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
    }

    /**
     * <p>
     * The name to use for the repository. The repository name may be specified on its own (such as
     * <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category (such
     * as <code>project-a/nginx-web-app</code>).
     * </p>
     * 
     * @return The name to use for the repository. The repository name may be specified on its own (such as
     *         <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a
     *         category (such as <code>project-a/nginx-web-app</code>).
     */
    public String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of a
     * key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
     * characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata that you apply to the repository to help you categorize and organize them. Each tag consists
     *         of a key and an optional value, both of which you define. Tag keys can have a maximum character length of
     *         128 characters, and tag values can have a maximum length of 256 characters.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
     * specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     *         <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
     *         <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
     *         prevent them from being overwritten.
     * @see ImageTagMutability
     */
    public ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(imageTagMutability);
    }

    /**
     * <p>
     * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
     * specified, all image tags within the repository will be immutable which will prevent them from being overwritten.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageTagMutability} will return {@link ImageTagMutability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #imageTagMutabilityAsString}.
     * </p>
     * 
     * @return The tag mutability setting for the repository. If this parameter is omitted, the default setting of
     *         <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
     *         <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
     *         prevent them from being overwritten.
     * @see ImageTagMutability
     */
    public String imageTagMutabilityAsString() {
        return imageTagMutability;
    }

    /**
     * <p>
     * The image scanning configuration for the repository. This setting determines whether images are scanned for known
     * vulnerabilities after being pushed to the repository.
     * </p>
     * 
     * @return The image scanning configuration for the repository. This setting determines whether images are scanned
     *         for known vulnerabilities after being pushed to the repository.
     */
    public ImageScanningConfiguration imageScanningConfiguration() {
        return imageScanningConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(imageTagMutabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageScanningConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest) obj;
        return Objects.equals(repositoryName(), other.repositoryName()) && Objects.equals(tags(), other.tags())
                && Objects.equals(imageTagMutabilityAsString(), other.imageTagMutabilityAsString())
                && Objects.equals(imageScanningConfiguration(), other.imageScanningConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRepositoryRequest").add("RepositoryName", repositoryName()).add("Tags", tags())
                .add("ImageTagMutability", imageTagMutabilityAsString())
                .add("ImageScanningConfiguration", imageScanningConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "imageTagMutability":
            return Optional.ofNullable(clazz.cast(imageTagMutabilityAsString()));
        case "imageScanningConfiguration":
            return Optional.ofNullable(clazz.cast(imageScanningConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRepositoryRequest, T> g) {
        return obj -> g.apply((CreateRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRepositoryRequest> {
        /**
         * <p>
         * The name to use for the repository. The repository name may be specified on its own (such as
         * <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a category
         * (such as <code>project-a/nginx-web-app</code>).
         * </p>
         * 
         * @param repositoryName
         *        The name to use for the repository. The repository name may be specified on its own (such as
         *        <code>nginx-web-app</code>) or it can be prepended with a namespace to group the repository into a
         *        category (such as <code>project-a/nginx-web-app</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of
         * a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the repository to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         *        character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of
         * a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The metadata that you apply to the repository to help you categorize and organize them. Each tag
         *        consists of a key and an optional value, both of which you define. Tag keys can have a maximum
         *        character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the repository to help you categorize and organize them. Each tag consists of
         * a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128
         * characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
         * specified, all image tags within the repository will be immutable which will prevent them from being
         * overwritten.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         *        <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
         *        <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
         *        prevent them from being overwritten.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(String imageTagMutability);

        /**
         * <p>
         * The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         * <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If <code>IMMUTABLE</code> is
         * specified, all image tags within the repository will be immutable which will prevent them from being
         * overwritten.
         * </p>
         * 
         * @param imageTagMutability
         *        The tag mutability setting for the repository. If this parameter is omitted, the default setting of
         *        <code>MUTABLE</code> will be used which will allow image tags to be overwritten. If
         *        <code>IMMUTABLE</code> is specified, all image tags within the repository will be immutable which will
         *        prevent them from being overwritten.
         * @see ImageTagMutability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageTagMutability
         */
        Builder imageTagMutability(ImageTagMutability imageTagMutability);

        /**
         * <p>
         * The image scanning configuration for the repository. This setting determines whether images are scanned for
         * known vulnerabilities after being pushed to the repository.
         * </p>
         * 
         * @param imageScanningConfiguration
         *        The image scanning configuration for the repository. This setting determines whether images are
         *        scanned for known vulnerabilities after being pushed to the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration);

        /**
         * <p>
         * The image scanning configuration for the repository. This setting determines whether images are scanned for
         * known vulnerabilities after being pushed to the repository.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageScanningConfiguration.Builder} avoiding the
         * need to create one manually via {@link ImageScanningConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageScanningConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #imageScanningConfiguration(ImageScanningConfiguration)}.
         * 
         * @param imageScanningConfiguration
         *        a consumer that will call methods on {@link ImageScanningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageScanningConfiguration(ImageScanningConfiguration)
         */
        default Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return imageScanningConfiguration(ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String repositoryName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String imageTagMutability;

        private ImageScanningConfiguration imageScanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            super(model);
            repositoryName(model.repositoryName);
            tags(model.tags);
            imageTagMutability(model.imageTagMutability);
            imageScanningConfiguration(model.imageScanningConfiguration);
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getImageTagMutabilityAsString() {
            return imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return imageScanningConfiguration != null ? imageScanningConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
