/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.Protocol;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ecr.model.StartLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.transform.StartLifecyclePolicyPreviewRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StartLifecyclePolicyPreviewRequestMarshaller
implements Marshaller<Request<StartLifecyclePolicyPreviewRequest>, StartLifecyclePolicyPreviewRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.AWS_JSON).requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonEC2ContainerRegistry_V20150921.StartLifecyclePolicyPreview").serviceName("Amazon ECR").build();
    private final SdkJsonProtocolFactory protocolFactory;

    public StartLifecyclePolicyPreviewRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<StartLifecyclePolicyPreviewRequest> marshall(StartLifecyclePolicyPreviewRequest startLifecyclePolicyPreviewRequest) {
        Validate.paramNotNull((Object)((Object)startLifecyclePolicyPreviewRequest), (String)"startLifecyclePolicyPreviewRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)startLifecyclePolicyPreviewRequest);
            protocolMarshaller.startMarshalling();
            StartLifecyclePolicyPreviewRequestModelMarshaller.getInstance().marshall(startLifecyclePolicyPreviewRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

