/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.LayerFailure;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LayerFailureMarshaller {
    private static final MarshallingInfo<String> LAYERDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerDigest").isBinary(false).build();
    private static final MarshallingInfo<String> FAILURECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureCode").isBinary(false).build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failureReason").isBinary(false).build();
    private static final LayerFailureMarshaller INSTANCE = new LayerFailureMarshaller();

    private LayerFailureMarshaller() {
    }

    public static LayerFailureMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LayerFailure layerFailure, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)layerFailure, (String)"layerFailure");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)layerFailure.layerDigest(), LAYERDIGEST_BINDING);
            protocolMarshaller.marshall((Object)layerFailure.failureCodeString(), FAILURECODE_BINDING);
            protocolMarshaller.marshall((Object)layerFailure.failureReason(), FAILUREREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

