/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResult;

@SdkInternalApi
public class LifecyclePolicyPreviewResultMarshaller {
    private static final MarshallingInfo<List> IMAGETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTags").build();
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").build();
    private static final MarshallingInfo<Instant> IMAGEPUSHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePushedAt").build();
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").build();
    private static final MarshallingInfo<Integer> APPLIEDRULEPRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appliedRulePriority").build();
    private static final LifecyclePolicyPreviewResultMarshaller INSTANCE = new LifecyclePolicyPreviewResultMarshaller();

    public static LifecyclePolicyPreviewResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LifecyclePolicyPreviewResult lifecyclePolicyPreviewResult, ProtocolMarshaller protocolMarshaller) {
        if (lifecyclePolicyPreviewResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(lifecyclePolicyPreviewResult.imageTags(), IMAGETAGS_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.imageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.imagePushedAt(), IMAGEPUSHEDAT_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.appliedRulePriority(), APPLIEDRULEPRIORITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

