/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ecr.ECRClient;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;

public final class ListImagesPaginator
implements SdkIterable<ListImagesResponse> {
    private final ECRClient client;
    private final ListImagesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListImagesPaginator(ECRClient client, ListImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImagesResponseFetcher();
    }

    public Iterator<ListImagesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ImageIdentifier> imageIds() {
        Function<ListImagesResponse, Iterator> getIterator = response -> response != null ? response.imageIds().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListImagesResponseFetcher
    implements NextPageFetcher<ListImagesResponse> {
        private ListImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListImagesResponse nextPage(ListImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagesPaginator.this.client.listImages(ListImagesPaginator.this.firstRequest);
            }
            return ListImagesPaginator.this.client.listImages((ListImagesRequest)((Object)ListImagesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

