/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.ImageFailureCode;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.transform.ImageFailureMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageFailure
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageFailure> {
    private final ImageIdentifier imageId;
    private final String failureCode;
    private final String failureReason;

    private ImageFailure(BuilderImpl builder) {
        this.imageId = builder.imageId;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    public ImageIdentifier imageId() {
        return this.imageId;
    }

    public ImageFailureCode failureCode() {
        return ImageFailureCode.fromValue(this.failureCode);
    }

    public String failureCodeString() {
        return this.failureCode;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageFailure)) {
            return false;
        }
        ImageFailure other = (ImageFailure)obj;
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.failureCodeString(), other.failureCodeString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.failureCodeString() != null) {
            sb.append("FailureCode: ").append(this.failureCodeString()).append(",");
        }
        if (this.failureReason() != null) {
            sb.append("FailureReason: ").append(this.failureReason()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "failureCode": {
                return Optional.of(clazz.cast(this.failureCodeString()));
            }
            case "failureReason": {
                return Optional.of(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageFailureMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private ImageIdentifier imageId;
        private String failureCode;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageFailure model) {
            this.imageId(model.imageId);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(ImageFailureCode failureCode) {
            this.failureCode(failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public ImageFailure build() {
            return new ImageFailure(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageFailure> {
        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().apply(imageId)).build());
        }

        public Builder failureCode(String var1);

        public Builder failureCode(ImageFailureCode var1);

        public Builder failureReason(String var1);
    }
}

